/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.migration.runners;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.IterableQueryResult;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.osivia.migration.runners.AbstractRunner;
import org.osivia.migration.transaction.LauncherTransactionHelper;

public class LocalLivesRunner
extends AbstractRunner {
    private static final Log log = LogFactory.getLog(LocalLivesRunner.class);
    private static final String PS_QUERY = "select * from Document where ecm:mixinType = 'TTCPublishSpace' and ecm:mixinType <> 'isLocalPublishLive' and ecm:isProxy = 0 AND ecm:isVersion = 0";

    public LocalLivesRunner(CoreSession session) {
        super(session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setInputs(int limit) {
        int size = 0;
        try (IterableQueryResult publishSpacesIds = null;){
            publishSpacesIds = this.getPublishSpaces(this.session);
            this.inputs = this.getLocalLives(this.session, publishSpacesIds, limit);
            size = this.inputs.size();
            if (size == 0) {
                this.inputs = this.session.query(PS_QUERY, limit);
                size = this.inputs.size();
            }
            this.totalInputs += size;
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() throws ClientException {
        LauncherTransactionHelper.checkNStartTransaction();
        try {
            for (DocumentModel localLive : this.inputs) {
                if (localLive.hasFacet("isLocalPublishLive") || !localLive.addFacet("isLocalPublishLive")) continue;
                this.session.saveDocument(localLive);
                ++this.treatedInputs;
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)(localLive.getPathAsString() + " migrated"));
            }
            this.session.save();
        }
        catch (Exception e) {
            LauncherTransactionHelper.setTransactionRollbackOnly();
            log.error((Object)e);
        }
        finally {
            LauncherTransactionHelper.commitOrRollbackTransaction();
        }
    }

    private IterableQueryResult getPublishSpaces(CoreSession session) {
        String request = "select ecm:uuid from Document where %s and ecm:mixinType = 'TTCPublishSpace'";
        String query = String.format(request, " ecm:isProxy = 0 AND ecm:isVersion = 0 AND ecm:currentLifeCycleState != 'deleted'");
        return session.queryAndFetch(query, "NXQL", new Object[0]);
    }

    private DocumentModelList getLocalLives(CoreSession session, IterableQueryResult publishSpacesIds, int limit) {
        this.inputs = new DocumentModelListImpl(0);
        if (publishSpacesIds != null) {
            Iterator iterator = publishSpacesIds.iterator();
            int totalRes = 0;
            while (iterator.hasNext() && totalRes < limit) {
                String request;
                DocumentModelList res;
                Map next = (Map)iterator.next();
                if (next == null || (res = session.query(request = String.format("select * from Document where %s and ecm:mixinType <> 'isLocalPublishLive' and ecm:ancestorId = '%s' ", " ecm:isProxy = 0 AND ecm:isVersion = 0 AND ecm:currentLifeCycleState != 'deleted'", (String)next.get("ecm:uuid")), limit)).size() <= 0) continue;
                this.inputs.addAll((Collection)res);
                totalRes += res.size();
            }
        }
        return this.inputs;
    }

    @Deprecated
    private String getSpaceIdsSet(IterableQueryResult publishSpacesIds) {
        Iterator iterator;
        StringBuffer set = new StringBuffer();
        if (publishSpacesIds != null && (iterator = publishSpacesIds.iterator()).hasNext()) {
            set.append("(");
            while (iterator.hasNext()) {
                Map row = (Map)iterator.next();
                set.append("'").append(row.get("ecm:uuid")).append("'");
                if (!iterator.hasNext()) continue;
                set.append(",");
            }
            set.append(")");
        }
        return set.toString();
    }
}

