/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.migration.runners;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.platform.picture.api.ImagingService;
import org.nuxeo.ecm.platform.picture.api.adapters.PictureResourceAdapter;
import org.nuxeo.runtime.api.Framework;
import org.osivia.migration.runners.AbstractRunner;
import org.osivia.migration.transaction.LauncherTransactionHelper;

public class ThumbnailPictureRunner
extends AbstractRunner {
    private static final Log log = LogFactory.getLog(ThumbnailPictureRunner.class);
    private static Set<String> requestedIds = new HashSet<String>(500);
    private static String PICT_MISSING_THUMB_VIEW_QUERY = "select * from Picture where  ecm:isProxy = 0 and ecm:isVersion = 0 and picture:views/4/content/data is null";
    protected static final String XPATH = "file:content";
    private static ImagingService imagingService;

    protected static ImagingService getImagingService() {
        if (imagingService == null) {
            imagingService = (ImagingService)Framework.getService(ImagingService.class);
        }
        return imagingService;
    }

    public ThumbnailPictureRunner(CoreSession session) {
        super(session);
    }

    @Override
    public int setInputs(int limit) {
        int size = 0;
        this.inputs = this.session.query(PICT_MISSING_THUMB_VIEW_QUERY, limit);
        ListIterator listIterator = this.inputs.listIterator();
        while (listIterator.hasNext()) {
            String id = ((DocumentModel)listIterator.next()).getId();
            if (!requestedIds.contains(id)) continue;
            listIterator.remove();
        }
        size = this.inputs.size();
        this.totalInputs += size;
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() throws ClientException {
        if (this.inputs.size() > 0) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"[----- Migrating pictures -----]");
            }
            long begin = System.currentTimeMillis();
            LauncherTransactionHelper.checkNStartTransaction();
            try {
                for (DocumentModel picture : this.inputs) {
                    requestedIds.add(picture.getId());
                    Blob blob = this.fillThumbnailView(picture);
                    if (blob != null) {
                        this.manageVersions(blob, picture);
                    }
                    this.session.save();
                }
            }
            catch (Exception e) {
                LauncherTransactionHelper.setTransactionRollbackOnly();
                log.error((Object)e);
            }
            finally {
                LauncherTransactionHelper.commitOrRollbackTransaction();
            }
            if (log.isDebugEnabled()) {
                long end = System.currentTimeMillis();
                log.debug((Object)("[----- Pictures migrated: " + String.valueOf(end - begin) + " ms -----]"));
            }
        }
    }

    private Blob fillThumbnailView(DocumentModel picture) throws ClientException, IOException {
        if (log.isTraceEnabled() && picture != null) {
            log.trace((Object)("Treating picture: " + picture.getPathAsString()));
        }
        PictureResourceAdapter pictureAdapter = (PictureResourceAdapter)picture.getAdapter(PictureResourceAdapter.class);
        Property fileProp = picture.getProperty(XPATH);
        Blob blob = (Blob)fileProp.getValue();
        if (blob == null) {
            log.debug((Object)("Picture: " + picture.getPathAsString() + " has no blob"));
            return null;
        }
        String filename = blob.getFilename();
        pictureAdapter.fillPictureViews(blob, filename, picture.getTitle(), null);
        if (picture.isVersion()) {
            picture.putContextData("allowVersionWrite", (Serializable)Boolean.TRUE);
        }
        this.session.saveDocument(picture);
        ++this.treatedInputs;
        return blob;
    }

    private void manageVersions(Blob blob, DocumentModel picture) throws ClientException, IOException {
        List versions = this.session.getVersions(picture.getRef());
        for (DocumentModel version : versions) {
            Property fileProp = version.getProperty(XPATH);
            Blob vBlob = (Blob)fileProp.getValue();
            if (vBlob == null || !StringUtils.equals((String)blob.getFilename(), (String)vBlob.getFilename())) continue;
            requestedIds.add(version.getId());
            this.fillThumbnailView(version);
        }
    }
}

