CREATE OR REPLACE FUNCTION generateWebIds() RETURNS void AS $$

DECLARE
	ttcDoc varchar(36);
	versions varchar(36)[];
	is_version boolean := FALSE;
	web_id char(6);
	processed_doc integer := 0;
	total_doc integer;
BEGIN
	RAISE NOTICE 'Starting webId generation';

	-- le total de document à traiter (pas forcément de génération)
	SELECT count(id) INTO total_doc FROM toutatice WHERE webid IS NULL;

	-- pour tout les doc toutatice sans webid
	FOR ttcDoc IN SELECT id FROM toutatice WHERE webid IS NULL LOOP

		-- si c'est une version on l'ignore
		SELECT isversion INTO is_version FROM hierarchy WHERE id = ttcDoc;
		IF is_version IS NOT TRUE THEN
			-- sinon on récupère toute les versions
			versions := array(SELECT id FROM versions WHERE versionableid = ttcDoc);

			-- on génère le webid
			SELECT array_to_string(array((SELECT SUBSTRING('ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz123456789' FROM trunc(random() * 63)::int FOR 1) INTO web_id FROM generate_series(1,6))),''); 

			-- maj le ttcDoc et ses version avec le ttc:webid
			UPDATE toutatice SET webid = web_id WHERE id = ANY (versions || ttcDoc);
		END IF;

		processed_doc := processed_doc + 1;
		IF processed_doc % 1000 = 0 THEN
			RAISE INFO '% out of % documents processed', processed_doc, total_doc;
		END IF;
	END LOOP;

	RAISE NOTICE 'webId generation DONE, % documents processed ', processed_doc;

END ; $$ LANGUAGE plpgsql;
