/**
 * 
 */
package org.osivia.migration.runners;

import java.util.ArrayList;
import java.util.List;

import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.event.EventService;
import org.nuxeo.ecm.core.versioning.VersioningService;

import fr.toutatice.ecm.platform.core.helper.ToutaticeSilentProcessRunnerHelper;

/**
 * @author david
 *
 */
public abstract class AbstractRunner extends ToutaticeSilentProcessRunnerHelper {
	
	/** Default repository. */
	public static final String DEFAULT_REPO = "default";
	
	/** ottc version key property of current Nuxeo instance. */
	public static final String OTTC_VERSION_PROPERTY = "ottc.version";
	
	/** Done migration status. */
	public static final String MIGRATION_DONE = "done";
	
	/** Default filter */
	public static final String FIXED_CLAUSE = "ecm:mixinType != 'HiddenInNavigation' AND ecm:isProxy = 0 AND ecm:isVersion = 0 AND ecm:currentLifeCycleState != 'deleted'";
	
	/** Empty id filter */
	public static final String EMPTY_ID_FILTER = "ecm:isProxy = 0 AND ecm:isVersion = 0 AND ecm:currentLifeCycleState != 'deleted'";
	
	/** Silent services. */
	public static final List<Class<?>> FILTERED_SERVICES_LIST = new ArrayList<Class<?>>() {
		private static final long serialVersionUID = 1L;

		{
			add(EventService.class);
			add(VersioningService.class);
		}
	};

	public AbstractRunner(CoreSession session) {
		super(session);
	}
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public abstract void run() throws ClientException; 

}
