/**
 * 
 */

package org.osivia.migration.runners;

import java.util.Iterator;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.osivia.migration.transaction.LauncherTransactionHelper;

import fr.toutatice.ecm.platform.core.constants.ToutaticeNuxeoStudioConst;
import fr.toutatice.ecm.platform.core.helper.ToutaticeDocumentHelper;


/**
 * @author david
 */
public class LocalLivesRunner extends AbstractRunner {
	
	private static final Log log = LogFactory.getLog(LocalLivesRunner.class);
	
	public LocalLivesRunner(CoreSession session) {
		super(session);
	}
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public void run() throws ClientException {
		
		log.debug("===== Beginning of LocalLives migration =====");
		int totalDocs = 0;
		int treatedDocs = 0;
		
		LauncherTransactionHelper.checkNStartTransaction();
		try {
		
			DocumentModelList publishSpaces = getPublishSpaces(this.session);
			DocumentModelList localLives = getLocalLives(this.session, publishSpaces);
			
			for(DocumentModel localLive : localLives){
				if(ToutaticeDocumentHelper.isInPublishSpace(this.session, localLive) && !localLive.isProxy() && !localLive.isVersion()){
					totalDocs += 1;
		            if(!localLive.hasFacet("isLocalPublishLive")){
		            	if(localLive.addFacet("isLocalPublishLive")){
			                this.session.saveDocument(localLive);
			                treatedDocs += 1;
			                log.debug(localLive.getPathAsString() + " migrated");
		            	}
		            }
		        }
			}
			
			this.session.save();
		
		LauncherTransactionHelper.commitOrRollbackTransaction();

		} catch (Exception e) {
			LauncherTransactionHelper.setTransactionRollbackOnly();
			log.error(e);
		}
		
		log.debug("===== End of LocalLives migration : ".concat(String.valueOf(treatedDocs)).concat(" on ").concat(String.valueOf(totalDocs)).concat(" ====="));
	}
	
	/**
	 * @param session
	 * @return the plush spaces of repository.
	 */
	private DocumentModelList getPublishSpaces(CoreSession session) {
		String request = "select * from Document where %s and ecm:mixinType = 'TTCPublishSpace'";
		String query = String.format(request, FIXED_CLAUSE);
		return session.query(query);
	}
	
	/**
	 * @param session
	 * @param publishSpaces
	 * @return local lives of given publish spaces.
	 */
	private DocumentModelList getLocalLives(CoreSession session,
			DocumentModelList publishSpaces) {
		String spaceIdsSet = getSpaceIdsSet(publishSpaces);
		
		String request = String.format("select * from Document where %s and ttc:spaceID in %s", FIXED_CLAUSE, spaceIdsSet);
		return session.query(request);
	}
	
	/**
	 * @param publishSpaces
	 * @return the spaceIds set for query.
	 */
	private String getSpaceIdsSet(DocumentModelList publishSpaces) {
		StringBuffer set = new StringBuffer();
		
		if(!publishSpaces.isEmpty()){
			set.append("(");
			
			Iterator<DocumentModel> iterator = publishSpaces.iterator();
			while(iterator.hasNext()){
				DocumentModel publishSpace = iterator.next();
				set.append("'").append(publishSpace.getId()).append("'");
				
				if(iterator.hasNext()){
					set.append(",");
				}
			}
			
			set.append(")");
		}
		
		
		return set.toString();
	}

}
