/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.migration.runners;

import fr.toutatice.ecm.platform.core.helper.ToutaticeSilentProcessRunnerHelper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.IterableQueryResult;
import org.nuxeo.ecm.core.event.EventService;
import org.nuxeo.ecm.core.versioning.VersioningService;
import org.osivia.migration.transaction.LauncherTransactionHelper;

public abstract class AbstractRunner
extends ToutaticeSilentProcessRunnerHelper {
    private static final Log log = LogFactory.getLog(AbstractRunner.class);
    public static final String MIGRATION_DONE = "done";
    public static final String FIXED_CLAUSE = " ecm:isProxy = 0 AND ecm:isVersion = 0 AND ecm:currentLifeCycleState != 'deleted'";
    public static final String EMPTY_ID_FILTER = "ecm:isProxy = 0 AND ecm:isVersion = 0 AND ecm:currentLifeCycleState != 'deleted'";
    public static final List<Class<?>> FILTERED_SERVICES_LIST = new ArrayList<Class<?>>(){
        private static final long serialVersionUID = 1L;
        {
            this.add(EventService.class);
            this.add(VersioningService.class);
        }
    };
    protected DocumentModelList inputs;
    protected IterableQueryResult results;
    protected String params;
    protected int totalInputs;
    protected int treatedInputs;
    protected static List<String> docsOnError = new ArrayList<String>();

    public int getTotalInputs() {
        return this.totalInputs;
    }

    public int getTreatedInputs() {
        return this.treatedInputs;
    }

    public abstract int setInputs(int var1);

    public AbstractRunner(CoreSession session) {
        super(session);
    }

    public void setParams(String params) {
        this.params = params;
    }

    public static List<String> getDocsOnError() {
        return docsOnError;
    }

    public static void resetDocsOnerror() {
        docsOnError.clear();
    }

    protected DocumentModelList removeDocsWithError(DocumentModelList inputs) {
        Iterator iterator = inputs.iterator();
        while (iterator.hasNext()) {
            String id = ((DocumentModel)iterator.next()).getId();
            if (!docsOnError.contains(id)) continue;
            iterator.remove();
        }
        return inputs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runSilentlyInTx(boolean unrestricted) {
        LauncherTransactionHelper.checkNStartTransaction();
        try {
            this.silentRun(unrestricted, FILTERED_SERVICES_LIST);
        }
        catch (Exception e) {
            LauncherTransactionHelper.setTransactionRollbackOnly();
            log.error((Object)e);
        }
        finally {
            LauncherTransactionHelper.commitOrRollbackTransaction();
        }
    }

    public abstract void run() throws ClientException;
}

