/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.portal.api.portlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import javax.portlet.PortletException;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.osivia.portal.api.directory.v2.model.Person;
import org.osivia.portal.api.directory.v2.service.PersonService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.portlet.bind.annotation.ResourceMapping;

public abstract class PortletController {
    @Autowired
    protected PersonService personService;

    @ResourceMapping(value="person-search")
    public void personSearch(ResourceRequest request, ResourceResponse response, @RequestParam(value="filter", required=false) String filter) throws PortletException, IOException {
        ArrayList<JSONObject> objects = new ArrayList<JSONObject>();
        int total = 0;
        List<Person> persons = this.searchPersons(filter);
        for (Person person : persons) {
            String extra;
            String displayName;
            JSONObject object = new JSONObject();
            object.put((Object)"id", (Object)person.getUid());
            if (StringUtils.isEmpty((String)person.getDisplayName())) {
                displayName = person.getUid();
                extra = null;
            } else {
                displayName = person.getDisplayName();
                extra = person.getUid();
                if (StringUtils.isNotBlank((String)person.getMail()) && !StringUtils.equals((String)person.getUid(), (String)person.getMail())) {
                    extra = extra + " \u2013 " + person.getMail();
                }
            }
            object.put((Object)"displayName", (Object)displayName);
            object.put((Object)"extra", (Object)extra);
            object.put((Object)"avatar", (Object)person.getAvatar().getUrl());
            objects.add(object);
            ++total;
        }
        JSONObject results = new JSONObject();
        JSONArray items = new JSONArray();
        items.addAll(objects);
        results.put((Object)"items", (Object)items);
        results.put((Object)"total", (Object)total);
        response.setContentType("application/json");
        PrintWriter printWriter = new PrintWriter(response.getPortletOutputStream());
        printWriter.write(results.toString());
        printWriter.close();
    }

    private List<Person> searchPersons(String filter) throws PortletException {
        Person criteria = this.personService.getEmptyPerson();
        String strippedFilter = StringUtils.strip((String)StringUtils.trimToEmpty((String)filter), (String)"*");
        String tokenizedFilter = strippedFilter + "*";
        String tokenizedFilterSubStr = StringUtils.isEmpty((String)strippedFilter) ? tokenizedFilter : "*" + strippedFilter + "*";
        criteria.setUid(tokenizedFilter);
        criteria.setCn(tokenizedFilter);
        criteria.setSn(tokenizedFilter);
        criteria.setGivenName(tokenizedFilter);
        criteria.setMail(tokenizedFilter);
        criteria.setDisplayName(tokenizedFilterSubStr);
        return this.personService.findByCriteria(criteria);
    }
}

