/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.portal.api.cms.impl;

import java.util.Collection;
import java.util.Hashtable;
import java.util.Map;
import org.osivia.portal.api.cms.DocumentContext;
import org.osivia.portal.api.cms.DocumentType;
import org.osivia.portal.api.cms.EcmDocument;
import org.osivia.portal.api.cms.Permissions;
import org.osivia.portal.api.cms.PublicationInfos;
import org.osivia.portal.api.cms.impl.BasicPermissions;
import org.osivia.portal.api.cms.impl.BasicPublicationInfos;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDocumentContext<D extends EcmDocument>
implements DocumentContext<D> {
    protected D document;
    public static final String HIDE_METADATA = "osivia.cms.hideMetaDatas";
    private Map<Class<? extends Permissions>, Permissions> permissionsMap = new Hashtable<Class<? extends Permissions>, Permissions>();
    private Map<Class<? extends PublicationInfos>, PublicationInfos> publicationInfosMap = new Hashtable<Class<? extends PublicationInfos>, PublicationInfos>();
    private DocumentType type;

    public AbstractDocumentContext() {
        this.permissionsMap.put(BasicPermissions.class, new BasicPermissions());
        this.publicationInfosMap.put(BasicPublicationInfos.class, new BasicPublicationInfos());
    }

    @Override
    public Collection<Permissions> getAllPermissions() {
        return this.permissionsMap.values();
    }

    @Override
    public void addPermissions(Permissions permissions) {
        this.permissionsMap.put(permissions.getClass(), permissions);
    }

    @Override
    public <P extends Permissions> P getPermissions(Class<P> permType) {
        return (P)this.permissionsMap.get(permType);
    }

    @Override
    public Collection<PublicationInfos> getAllPublicationInfos() {
        return this.publicationInfosMap.values();
    }

    @Override
    public <P extends PublicationInfos> P getPublicationInfos(Class<P> navType) {
        return (P)((PublicationInfos)navType.cast(this.publicationInfosMap.get(navType)));
    }

    @Override
    public void addPublicationInfos(PublicationInfos publicationInfos) {
        this.publicationInfosMap.put(publicationInfos.getClass(), publicationInfos);
    }

    @Override
    public DocumentType getType() {
        return this.type;
    }

    @Override
    public void setDocumentType(DocumentType type) {
        this.type = type;
    }
}

