/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.portal.api.portlet;

import javax.portlet.GenericPortlet;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.directory.IDirectoryService;
import org.osivia.portal.api.directory.IDirectoryServiceLocator;
import org.osivia.portal.api.internationalization.Bundle;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.portal.api.internationalization.IInternationalizationService;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.api.menubar.IMenubarService;
import org.osivia.portal.api.notifications.INotificationsService;
import org.osivia.portal.api.notifications.NotificationsType;
import org.osivia.portal.api.urls.IPortalUrlFactory;

public abstract class PortalGenericPortlet
extends GenericPortlet {
    private final INotificationsService notificationsService = Locator.findMBean(INotificationsService.class, "osivia:service=NotificationsService");
    private final IBundleFactory bundleFactory;
    private final IPortalUrlFactory portalUrlFactory;
    private final IDirectoryServiceLocator directoryServiceLocator;
    private final IMenubarService menubarService;

    public PortalGenericPortlet() {
        IInternationalizationService internationalizationService = Locator.findMBean(IInternationalizationService.class, "osivia:service=InternationalizationService");
        this.bundleFactory = internationalizationService.getBundleFactory(((Object)((Object)this)).getClass().getClassLoader());
        this.portalUrlFactory = Locator.findMBean(IPortalUrlFactory.class, "osivia:service=UrlFactory");
        this.directoryServiceLocator = Locator.findMBean(IDirectoryServiceLocator.class, "osivia:service=DirectoryServiceLocator");
        this.menubarService = Locator.findMBean(IMenubarService.class, "osivia:service=MenubarService");
    }

    public IDirectoryService getDirectoryService() {
        return this.directoryServiceLocator.getDirectoryService();
    }

    public INotificationsService getNotificationsService() {
        return this.notificationsService;
    }

    public IBundleFactory getBundleFactory() {
        return this.bundleFactory;
    }

    public IPortalUrlFactory getPortalUrlFactory() {
        return this.portalUrlFactory;
    }

    public IMenubarService getMenubarService() {
        return this.menubarService;
    }

    protected String getMessage(PortalControllerContext pcc, String label) {
        Bundle bundle = this.getBundleFactory().getBundle(pcc.getRequest().getLocale());
        return bundle.getString(label);
    }

    protected String getMessage(PortalControllerContext pcc, String label, Object ... args) {
        Bundle bundle = this.getBundleFactory().getBundle(pcc.getRequest().getLocale());
        return bundle.getString(label, args);
    }

    protected void addNotification(PortalControllerContext pcc, String label, NotificationsType notificationType) {
        String string = this.getMessage(pcc, label);
        this.getNotificationsService().addSimpleNotification(pcc, string, notificationType);
    }

    protected void addNotification(PortalControllerContext pcc, String label, NotificationsType notificationType, Object ... args) {
        String string = this.getMessage(pcc, label, args);
        this.getNotificationsService().addSimpleNotification(pcc, string, notificationType);
    }
}

