/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.portal.core.cms;

import org.osivia.portal.core.cms.Satellite;

public class CMSException
extends Exception {
    private static final long serialVersionUID = 1L;
    public static final int ERROR_FORBIDDEN = 1;
    public static final int ERROR_UNAVAILAIBLE = 2;
    public static final int ERROR_NOTFOUND = 3;
    private final int errorCode;
    private Satellite satellite;
    private String commandId;

    public String getCommandId() {
        return this.commandId;
    }

    public void setCommandId(String commandId) {
        this.commandId = commandId;
    }

    public Satellite getSatellite() {
        return this.satellite;
    }

    public void setSatellite(Satellite satellite) {
        this.satellite = satellite;
    }

    public CMSException(Throwable e) {
        super(e);
        this.errorCode = 0;
    }

    public CMSException(int errorCode) {
        this.errorCode = errorCode;
    }

    public CMSException(String message) {
        super(message);
        this.errorCode = 0;
    }

    public CMSException(String message, Throwable e) {
        super(message, e);
        this.errorCode = 0;
    }

    @Override
    public String getMessage() {
        StringBuilder message = new StringBuilder();
        Satellite satellite = this.satellite;
        if (satellite == null) {
            satellite = Satellite.MAIN;
        }
        String nuxeoSrc = "NUXEO/" + satellite.getId();
        message.append("Source=" + nuxeoSrc);
        if (this.commandId != null) {
            message.append(", Command=" + this.commandId);
        }
        if (this.errorCode > 0) {
            switch (this.errorCode) {
                case 1: {
                    message.append(", rc=403");
                    break;
                }
                case 3: {
                    message.append(", rc=404");
                }
            }
        }
        return message.toString();
    }

    public int getErrorCode() {
        return this.errorCode;
    }
}

