/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.server.impl.xml;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.jboss.portal.common.xml.XMLTools;
import org.jboss.portal.jems.as.system.AbstractJBossService;
import org.w3c.dom.Element;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class EntityResolverService
extends AbstractJBossService
implements EntityResolver {
    private Element dtdMapping;
    private Properties dtdMappingProps;

    public Element getDTDMapping() {
        return this.dtdMapping;
    }

    public void setDTDMapping(Element dtdMapping) {
        this.dtdMapping = dtdMapping;
        this.dtdMappingProps = this.dtdMapping != null ? XMLTools.loadXMLProperties((Element)dtdMapping) : null;
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        if (publicId == null) {
            return null;
        }
        String dtdResourceName = (String)this.dtdMappingProps.get(publicId);
        if (dtdResourceName != null) {
            this.log.debug((Object)("Looking up resource " + dtdResourceName + " for dtd publicId=" + publicId + ", systemId=" + systemId));
            InputStream dtdStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(dtdResourceName);
            if (dtdStream != null) {
                return new InputSource(dtdStream);
            }
            this.log.debug((Object)("No resource found for dtd publicId=" + publicId + ", systemId=" + systemId));
        } else {
            this.log.debug((Object)("No resource name found for dtd publicId=" + publicId + ", systemId=" + systemId));
        }
        return null;
    }

    public String toString() {
        return "EntityResolver[" + this.getServiceName() + "]";
    }
}

