/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.impl.model.instance.persistent;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.jboss.portal.common.i18n.LocalizedString;
import org.jboss.portal.core.impl.model.instance.AbstractInstanceDefinition;
import org.jboss.portal.core.impl.model.instance.InstanceContainerContext;
import org.jboss.portal.core.impl.model.instance.persistent.PersistentRoleSecurityBinding;
import org.jboss.portal.core.model.instance.metadata.InstanceMetaData;
import org.jboss.portal.jems.hibernate.ContextObject;
import org.jboss.portal.security.RoleSecurityBinding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PersistentInstanceDefinition
extends AbstractInstanceDefinition
implements ContextObject {
    protected Long key;
    protected String instanceId;
    protected boolean mutable;
    protected Map relatedSecurityBindings;
    protected Map relatedCustomizations;
    protected Map<Locale, String> displayNames;
    protected InstanceContainerContext containerContext;

    public PersistentInstanceDefinition() {
        this.mutable = false;
        this.portletRef = null;
        this.instanceId = null;
        this.relatedSecurityBindings = null;
        this.relatedCustomizations = null;
        this.state = null;
    }

    public PersistentInstanceDefinition(InstanceContainerContext containerContext, String id, String portletRef) {
        this.containerContext = containerContext;
        this.mutable = false;
        this.portletRef = portletRef;
        this.instanceId = id;
        this.relatedSecurityBindings = new HashMap();
        this.relatedCustomizations = new HashMap();
        this.displayNames = new HashMap<Locale, String>();
        this.state = null;
    }

    public PersistentInstanceDefinition(InstanceContainerContext containerContext, InstanceMetaData instanceMD) {
        this.containerContext = containerContext;
        this.mutable = false;
        this.portletRef = instanceMD.getPortletRef();
        this.instanceId = instanceMD.getId();
        this.displayNames = this.getDisplayNamesMap(instanceMD.getDisplayName());
        this.relatedSecurityBindings = new HashMap();
        this.relatedCustomizations = new HashMap();
        this.state = null;
    }

    private Map<Locale, String> getDisplayNamesMap(LocalizedString lString) {
        HashMap<Locale, String> map = new HashMap<Locale, String>();
        if (lString != null) {
            Map values = lString.getValues();
            for (Locale locale : values.keySet()) {
                map.put(locale, ((LocalizedString.Value)values.get(locale)).getString());
            }
        }
        return map;
    }

    @Override
    public LocalizedString getDisplayName() {
        return new LocalizedString(this.displayNames, Locale.ENGLISH);
    }

    @Override
    public void setDisplayName(LocalizedString localizedString) {
        if (localizedString == null) {
            throw new IllegalArgumentException("No null display name accepted");
        }
        this.displayNames = new HashMap<Locale, String>();
        Map map = localizedString.getValues();
        for (LocalizedString.Value value : map.values()) {
            this.displayNames.put(value.getLocale(), value.getString());
        }
    }

    public Long getKey() {
        return this.key;
    }

    public void setKey(Long key) {
        this.key = key;
    }

    @Override
    public String getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public Map getRelatedSecurityBindings() {
        return this.relatedSecurityBindings;
    }

    public void setRelatedSecurityBindings(Map relatedSecurityBindings) {
        this.relatedSecurityBindings = relatedSecurityBindings;
    }

    public Map getRelatedCustomizations() {
        return this.relatedCustomizations;
    }

    public void setDisplayNames(Map displayNames) {
        this.displayNames = displayNames;
    }

    public Map getDisplayNames() {
        return this.displayNames;
    }

    public void setRelatedCustomizations(Map relatedCustomizations) {
        this.relatedCustomizations = relatedCustomizations;
    }

    @Override
    public boolean isMutable() {
        return this.mutable;
    }

    @Override
    public void setMutable(boolean mutable) {
        this.mutable = mutable;
    }

    @Override
    public String getId() {
        return this.instanceId;
    }

    @Override
    public Collection getCustomizations() {
        return this.relatedCustomizations.values();
    }

    @Override
    public Set getSecurityBindings() {
        HashSet<RoleSecurityBinding> constraints = new HashSet<RoleSecurityBinding>();
        for (PersistentRoleSecurityBinding isc : this.relatedSecurityBindings.values()) {
            RoleSecurityBinding sc = new RoleSecurityBinding(isc.getActions(), isc.getRole());
            constraints.add(sc);
        }
        return constraints;
    }

    public void setContext(Object context) {
        this.containerContext = (InstanceContainerContext)context;
    }

    @Override
    protected InstanceContainerContext getContainerContext() {
        return this.containerContext;
    }
}

