/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.identity.ui.validators;

import java.util.ResourceBundle;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;
import javax.portlet.PortletContext;
import org.jboss.portal.identity.User;
import org.jboss.portal.identity.UserModule;

public class CurrentPasswordValidator
implements Validator {
    private UserModule userModule;

    public void validate(FacesContext context, UIComponent component, Object value) throws ValidatorException {
        User user;
        ResourceBundle bundle = ResourceBundle.getBundle("conf.bundles.Identity", context.getViewRoot().getLocale());
        PortletContext portletContext = (PortletContext)context.getExternalContext().getContext();
        this.userModule = (UserModule)portletContext.getAttribute("UserModule");
        String currentUser = context.getExternalContext().getRemoteUser();
        try {
            user = this.userModule.findUserByUserName(currentUser);
        }
        catch (Exception e) {
            throw new ValidatorException(new FacesMessage(FacesMessage.SEVERITY_ERROR, bundle.getString("IDENTITY_VALIDATION_ERROR_PASSWORD_ERROR"), bundle.getString("IDENTITY_VALIDATION_ERROR_PASSWORD_ERROR")));
        }
        if (user == null || !user.validatePassword((String)value)) {
            throw new ValidatorException(new FacesMessage(FacesMessage.SEVERITY_ERROR, bundle.getString("IDENTITY_VALIDATION_ERROR_INVALID_PASSWORD"), bundle.getString("IDENTITY_VALIDATION_ERROR_INVALID_PASSWORD")));
        }
    }
}

