/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.theme.deployment.jboss;

import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.MBeanServer;
import org.jboss.deployment.DeploymentException;
import org.jboss.portal.server.deployment.PortalWebApp;
import org.jboss.portal.server.deployment.jboss.AbstractDeploymentFactory;
import org.jboss.portal.server.deployment.jboss.Deployment;
import org.jboss.portal.theme.ThemeService;
import org.jboss.portal.theme.deployment.jboss.ThemeDeployment;

public class ThemeDeploymentFactory
extends AbstractDeploymentFactory {
    protected static final Pattern URL_PATTERN = Pattern.compile(".*-themes\\.xml");
    private ThemeService themeService;

    public boolean acceptFile(URL url) {
        String urlAsFile = url.getFile();
        Matcher matcher = URL_PATTERN.matcher(urlAsFile);
        return matcher.matches();
    }

    public Deployment newInstance(URL url, PortalWebApp pwa, MBeanServer mbeanServer) throws DeploymentException {
        return new ThemeDeployment(url, pwa, mbeanServer, this);
    }

    public ThemeService getThemeService() {
        return this.themeService;
    }

    public void setThemeService(ThemeService themeService) {
        this.themeService = themeService;
    }
}

