/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.distribution;

import java.io.Serializable;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.RMISocketFactory;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.List;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.distribution.CachePeer;
import net.sf.ehcache.distribution.ConfigurableRMIClientSocketFactory;
import net.sf.ehcache.distribution.EventMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RMICachePeer
extends UnicastRemoteObject
implements CachePeer,
Remote {
    private static final Log LOG = LogFactory.getLog((String)(class$net$sf$ehcache$distribution$RMICachePeer == null ? (class$net$sf$ehcache$distribution$RMICachePeer = RMICachePeer.class$("net.sf.ehcache.distribution.RMICachePeer")) : class$net$sf$ehcache$distribution$RMICachePeer).getName());
    private final String hostname;
    private final Integer port;
    private final Ehcache cache;
    static /* synthetic */ Class class$net$sf$ehcache$distribution$RMICachePeer;

    public RMICachePeer(Ehcache cache, String hostName, Integer port, Integer socketTimeoutMillis) throws RemoteException {
        super(0, new ConfigurableRMIClientSocketFactory(socketTimeoutMillis), RMISocketFactory.getDefaultSocketFactory());
        this.hostname = hostName;
        this.port = port;
        this.cache = cache;
    }

    public final String getUrl() {
        return "//" + this.hostname + ":" + this.port + "/" + this.cache.getName();
    }

    public final String getUrlBase() {
        return "//" + this.hostname + ":" + this.port;
    }

    public List getKeys() throws RemoteException {
        return this.cache.getKeys();
    }

    public Element getQuiet(Serializable key) throws RemoteException {
        return this.cache.getQuiet(key);
    }

    public List getElements(List keys) throws RemoteException {
        if (keys == null) {
            return new ArrayList();
        }
        ArrayList<Element> elements = new ArrayList<Element>();
        for (int i = 0; i < keys.size(); ++i) {
            Serializable key = (Serializable)keys.get(i);
            Element element = this.cache.getQuiet(key);
            elements.add(element);
        }
        return elements;
    }

    public void put(Element element) throws RemoteException, IllegalArgumentException, IllegalStateException {
        this.cache.put(element, true);
    }

    public final boolean remove(Serializable key) throws RemoteException, IllegalStateException {
        return this.cache.remove(key, true);
    }

    public final void removeAll() throws RemoteException, IllegalStateException {
        this.cache.removeAll();
    }

    public final void send(List eventMessages) throws RemoteException {
        for (int i = 0; i < eventMessages.size(); ++i) {
            EventMessage eventMessage = (EventMessage)eventMessages.get(i);
            if (eventMessage.getEvent() == 0) {
                this.put(eventMessage.getElement());
                continue;
            }
            this.remove(eventMessage.getSerializableKey());
        }
    }

    public final String getName() throws RemoteException {
        return this.cache.getName();
    }

    public final String getGuid() throws RemoteException {
        return this.cache.getGuid();
    }

    final Ehcache getBoundCacheInstance() {
        return this.cache;
    }

    public String toString() {
        return this.getUrl();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

