/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.portlet.controller;

import org.apache.log4j.Logger;
import org.jboss.portal.portlet.controller.event.EventControllerContext;
import org.jboss.portal.portlet.controller.event.EventPhaseContext;
import org.jboss.portal.portlet.controller.event.PortletWindowEvent;
import org.jboss.portal.portlet.invocation.response.PortletInvocationResponse;

class EventControllerContextSafeInvoker {
    private final Logger log = Logger.getLogger(EventControllerContextSafeInvoker.class);

    EventControllerContextSafeInvoker() {
    }

    public boolean eventProduced(EventControllerContext controllerContext, EventPhaseContext phaseContext, PortletWindowEvent sourceEvent, PortletWindowEvent producedEvent) {
        try {
            controllerContext.eventProduced(phaseContext, producedEvent, sourceEvent);
            return true;
        }
        catch (Exception e) {
            this.log.error((Object)("Cannot deliver produced event " + producedEvent + " because the event " + "controller context threw a runtime exception"), (Throwable)e);
            return false;
        }
    }

    public boolean eventConsumed(EventControllerContext controllerContext, EventPhaseContext phaseContext, PortletWindowEvent consumedEvent, PortletInvocationResponse consumerResponse) {
        try {
            controllerContext.eventConsumed(phaseContext, consumedEvent, consumerResponse);
            return true;
        }
        catch (Exception e) {
            this.log.error((Object)"Event consumed callback threw an exception that is ignored by the controller", (Throwable)e);
            return false;
        }
    }

    public boolean eventFailed(EventControllerContext controllerContext, EventPhaseContext phaseContext, PortletWindowEvent failedEvent, Throwable throwable) {
        try {
            controllerContext.eventFailed(phaseContext, failedEvent, throwable);
            return true;
        }
        catch (Exception e1) {
            this.log.error((Object)"Event delivery failed callback threw an exception that is ignored by the controller", (Throwable)e1);
            return false;
        }
    }

    public boolean eventDiscarded(EventControllerContext controllerContext, EventPhaseContext phaseContext, PortletWindowEvent discardedEvent, int cause) {
        try {
            controllerContext.eventDiscarded(phaseContext, discardedEvent, cause);
            return true;
        }
        catch (Exception e1) {
            this.log.error((Object)"Event delivery failed callback threw an exception that is ignored by the controller", (Throwable)e1);
            return false;
        }
    }
}

