/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MBeanServerBuilder;
import javax.management.MBeanServerDelegate;
import javax.management.MBeanServerPermission;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.loading.ClassLoaderRepository;
import org.jboss.mx.util.PropertyAccess;

public class MBeanServerFactory {
    private static final MBeanServerPermission CREATE = new MBeanServerPermission("createMBeanServer", null);
    private static final MBeanServerPermission FIND = new MBeanServerPermission("findMBeanServer", null);
    private static final MBeanServerPermission NEW = new MBeanServerPermission("newMBeanServer", null);
    private static final MBeanServerPermission RELEASE = new MBeanServerPermission("releaseMBeanServer", null);
    private static Map serverMap = new HashMap();

    private MBeanServerFactory() {
    }

    public static void releaseMBeanServer(MBeanServer mbeanServer) {
        MBeanServerFactory.checkPermission(RELEASE);
        try {
            String agentID = null;
            final MBeanServer theServer = mbeanServer;
            final ObjectName delegateName = new ObjectName("JMImplementation:type=MBeanServerDelegate");
            try {
                agentID = (String)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        return (String)theServer.getAttribute(delegateName, "MBeanServerId");
                    }
                });
            }
            catch (PrivilegedActionException e) {
                Exception ex = e.getException();
                if (ex instanceof JMException) {
                    throw (JMException)ex;
                }
                if (ex instanceof RuntimeException) {
                    throw (RuntimeException)ex;
                }
                JMException jex = new JMException("Unknown exception during getAttribute(MBeanServerId)");
                jex.initCause(ex);
                throw jex;
            }
            Object server = serverMap.remove(agentID);
            try {
                Method m = server.getClass().getMethod("releaseServer", null);
                m.invoke(server, null);
            }
            catch (Exception ignored) {
                // empty catch block
            }
            if (server == null) {
                throw new IllegalArgumentException("MBean server reference not found.");
            }
        }
        catch (MalformedObjectNameException e) {
            throw new Error(e.toString());
        }
        catch (JMException e) {
            throw new Error("Cannot retrieve AgentID: " + e.toString());
        }
    }

    public static MBeanServer createMBeanServer() {
        return MBeanServerFactory.createMBeanServer("DefaultDomain");
    }

    public static MBeanServer createMBeanServer(String domain) {
        MBeanServerFactory.checkPermission(CREATE);
        return MBeanServerFactory.createMBeanServer(domain, true);
    }

    public static MBeanServer newMBeanServer() {
        return MBeanServerFactory.newMBeanServer("DefaultDomain");
    }

    public static MBeanServer newMBeanServer(String domain) {
        MBeanServerFactory.checkPermission(NEW);
        return MBeanServerFactory.createMBeanServer(domain, false);
    }

    public static synchronized ArrayList findMBeanServer(String agentId) {
        MBeanServerFactory.checkPermission(FIND);
        if (agentId != null) {
            ArrayList list = new ArrayList(1);
            Object server = serverMap.get(agentId);
            if (server != null) {
                list.add(server);
            }
            return list;
        }
        return new ArrayList(serverMap.values());
    }

    public static ClassLoaderRepository getClassLoaderRepository(MBeanServer server) {
        return server.getClassLoaderRepository();
    }

    private static MBeanServer createMBeanServer(final String defaultDomain, boolean registerServer) {
        String builderClass = PropertyAccess.getProperty("javax.management.builder.initial", "org.jboss.mx.server.MBeanServerBuilderImpl");
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            Class<?> clazz = cl.loadClass(builderClass);
            Constructor<?> constructor = clazz.getConstructor(new Class[0]);
            final MBeanServerBuilder builder = (MBeanServerBuilder)constructor.newInstance(new Object[0]);
            final MBeanServerDelegate delegate = builder.newMBeanServerDelegate();
            MBeanServer server = null;
            try {
                server = (MBeanServer)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        return builder.newMBeanServer(defaultDomain, null, delegate);
                    }
                });
            }
            catch (PrivilegedActionException e) {
                RuntimeException re = (RuntimeException)e.getException();
                throw re;
            }
            if (registerServer) {
                String agentID = delegate.getMBeanServerId();
                serverMap.put(agentID, server);
            }
            return server;
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("The MBean server builder implementation class " + builderClass + " was not found: " + e.toString());
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("The MBean server builder implementation class " + builderClass + " must contain a default constructor.");
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("Cannot instantiate class " + builderClass + ": " + e.toString());
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Unable to create the MBean server builder instance. Illegal access to class " + builderClass + " constructor: " + e.toString());
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Unable to create the MBean server builder instance. Class " + builderClass + " has raised an exception in constructor: " + e.getTargetException().toString());
        }
    }

    private static void checkPermission(MBeanServerPermission permission) {
        SecurityManager security = System.getSecurityManager();
        if (security == null) {
            return;
        }
        security.checkPermission(permission);
    }
}

