/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.faces.component.scroller;

import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.component.UIForm;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.el.ValueBinding;
import javax.faces.render.Renderer;

public class ScrollerRenderer
extends Renderer {
    private final String PREVIOUS = "Previous";
    private final String NEXT = "Next";
    private final String FIRST = "First";
    private final String LAST = "Last";

    public void encodeBegin(FacesContext facesContext, UIComponent component) throws IOException {
        String styleClass = (String)this.getAttribute(facesContext, component, "styleClass");
        String datatableId = (String)this.getAttribute(facesContext, component, "for");
        UIComponent formComponent = component;
        while (!(formComponent instanceof UIForm)) {
            formComponent = formComponent.getParent();
        }
        String formComponentId = formComponent.getClientId(facesContext);
        ResponseWriter writer = facesContext.getResponseWriter();
        String id = this.getId(datatableId, component.getClientId(facesContext));
        UIData data = (UIData)this.findComponent((UIComponent)facesContext.getViewRoot(), facesContext, id);
        int first = data.getFirst();
        int rowCount = data.getRowCount();
        int pageSize = data.getRows();
        if (pageSize <= 0) {
            pageSize = rowCount;
        }
        int pages = rowCount / pageSize;
        if (rowCount % pageSize != 0) {
            ++pages;
        }
        int currentPage = first / pageSize;
        if (first >= rowCount - pageSize) {
            currentPage = pages - 1;
        }
        boolean startPage = false;
        int endPage = pages;
        if (currentPage > 0) {
            this.writeLink(writer, component, formComponentId, component.getClientId(facesContext), "Previous", styleClass);
        }
        if (first < rowCount - pageSize) {
            this.writeLink(writer, component, formComponentId, component.getClientId(facesContext), "Next", styleClass);
        }
        this.writeHiddenField(writer, component, component.getClientId(facesContext));
    }

    public void decode(FacesContext facesContext, UIComponent component) {
        String id = component.getClientId(facesContext);
        Map parameters = facesContext.getExternalContext().getRequestParameterMap();
        String response = (String)parameters.get(id);
        String datatableId = (String)this.getAttribute(facesContext, component, "for");
        String dataId = this.getId(datatableId, component.getClientId(facesContext));
        UIData data = (UIData)this.findComponent((UIComponent)facesContext.getViewRoot(), facesContext, dataId);
        int first = data.getFirst();
        int rowCount = data.getRowCount();
        int pageSize = data.getRows();
        if (pageSize <= 0) {
            pageSize = rowCount;
        }
        if (response.equals("Previous")) {
            first -= pageSize;
        } else if (response.equals("Next")) {
            first += pageSize;
        }
        if (first < 0) {
            first = 0;
        }
        data.setFirst(first);
    }

    private Object getAttribute(FacesContext facesContext, UIComponent component, String name) {
        ValueBinding vb = component.getValueBinding(name);
        if (vb != null) {
            return vb.getValue(facesContext);
        }
        return component.getAttributes().get(name);
    }

    public String getId(String id, String base) {
        String separator = ":";
        String[] idSplitted = id.split(separator);
        String[] baseSplitted = base.split(separator);
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < baseSplitted.length - idSplitted.length; ++i) {
            buffer.append(baseSplitted[i]);
            buffer.append(separator);
        }
        buffer.append(id);
        return buffer.toString();
    }

    private UIComponent findComponent(UIComponent component, FacesContext facesContext, String id) {
        String componentId = component.getClientId(facesContext);
        if (componentId.equals(id)) {
            return component;
        }
        for (UIComponent comp : component.getChildren()) {
            UIComponent found = this.findComponent(comp, facesContext, id);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    private void writeHiddenField(ResponseWriter writer, UIComponent component, String id) throws IOException {
        writer.startElement("input", component);
        writer.writeAttribute("type", (Object)"hidden", null);
        writer.writeAttribute("name", (Object)id, null);
        writer.endElement("input");
    }

    private void writeLink(ResponseWriter writer, UIComponent component, String formComponentId, String id, String value, String styleClass) throws IOException {
        writer.writeText((Object)" ", null);
        writer.startElement("input", component);
        writer.writeAttribute("value", (Object)value, null);
        writer.writeAttribute("type", (Object)"submit", null);
        writer.writeAttribute("onclick", (Object)this.onclickCode(formComponentId, id, value), null);
        if (styleClass != null) {
            writer.writeAttribute("class", (Object)styleClass, "styleClass");
        }
        writer.endElement("input");
    }

    private String onclickCode(String formComponentId, String id, String value) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("document.forms[");
        buffer.append("'");
        buffer.append(formComponentId);
        buffer.append("']");
        buffer.append(".elements['");
        buffer.append(id);
        buffer.append("'].value='");
        buffer.append(value);
        buffer.append("';");
        buffer.append(" document.forms[");
        buffer.append("'");
        buffer.append(formComponentId);
        buffer.append("'");
        buffer.append("].submit()");
        buffer.append("; return false;");
        return buffer.toString();
    }
}

