/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.identity.ldap;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.ldap.LdapContext;
import org.jboss.logging.Logger;
import org.jboss.portal.identity.CachedUserImpl;
import org.jboss.portal.identity.IdentityException;
import org.jboss.portal.identity.NoSuchUserException;
import org.jboss.portal.identity.User;
import org.jboss.portal.identity.UserModule;
import org.jboss.portal.identity.UserProfileModule;
import org.jboss.portal.identity.info.ProfileInfo;
import org.jboss.portal.identity.info.PropertyInfo;
import org.jboss.portal.identity.ldap.LDAPUserImpl;
import org.jboss.portal.identity.ldap.LDAPUserProfileModule;

public class LDAPUserProfileModuleImpl
extends LDAPUserProfileModule {
    private static final Logger log = Logger.getLogger(LDAPUserProfileModuleImpl.class);
    private UserModule userModule;

    public Object getProperty(User user, String propertyName) throws IdentityException, IllegalArgumentException {
        if (user == null) {
            throw new IllegalArgumentException("User cannot be null");
        }
        if (propertyName == null) {
            throw new IllegalArgumentException("Property name need to have value");
        }
        if (user instanceof CachedUserImpl) {
            try {
                user = this.getUserModule().findUserById(user.getId());
            }
            catch (NoSuchUserException e) {
                throw new IdentityException("Illegal state - cached user doesn't exist in identity store: ", e);
            }
        }
        LDAPUserImpl ldapUser = null;
        if (!(user instanceof LDAPUserImpl)) {
            throw new IllegalArgumentException("This UserProfileModule implementation supports only LDAPUserImpl objects");
        }
        ldapUser = (LDAPUserImpl)user;
        String attributeName = this.resolveAttributeName(propertyName);
        Object propertyValue = null;
        if (attributeName == null) {
            log.error((Object)("Proper LDAP attribute mapping not found for such property name: " + propertyName));
            return null;
        }
        LdapContext ldapContext = this.getConnectionContext().createInitialContext();
        try {
            Attributes attrs = ldapContext.getAttributes(ldapUser.getDn());
            Attribute attr = attrs.get(attributeName);
            if (attr != null) {
                propertyValue = attr.get();
            } else {
                log.error((Object)("No such attribute ('" + attributeName + "') in entry: " + ldapUser.getDn()));
            }
        }
        catch (NamingException e) {
            throw new IdentityException("Cannot get user property value.", e);
        }
        finally {
            try {
                ldapContext.close();
            }
            catch (NamingException e) {
                throw new IdentityException("Failed to close LDAP connection", e);
            }
        }
        PropertyInfo pi = this.getProfileInfo().getPropertyInfo(propertyName);
        if (propertyValue != null && !pi.getType().equals(propertyValue.getClass().getName())) {
            log.error((Object)("Error on processing property:" + propertyName));
            log.error((Object)("Wrong property type retreived from LDAP. Should be: " + pi.getType() + "; and found: " + propertyValue.getClass().getName()));
        }
        return propertyValue;
    }

    public void setProperty(User user, String propertyName, Object property) throws IdentityException, IllegalArgumentException {
        if (user == null) {
            throw new IllegalArgumentException("User cannot be null");
        }
        if (propertyName == null) {
            throw new IllegalArgumentException("Property name need to have value");
        }
        if (user instanceof CachedUserImpl) {
            try {
                user = this.getUserModule().findUserById(user.getId());
            }
            catch (NoSuchUserException e) {
                throw new IdentityException("Illegal state - cached user doesn't exist in identity store: ", e);
            }
        }
        LDAPUserImpl ldapUser = null;
        if (!(user instanceof LDAPUserImpl)) {
            throw new IllegalArgumentException("This UserProfileModule implementation support only LDAPUserImpl objects");
        }
        ldapUser = (LDAPUserImpl)user;
        String attributeName = this.resolveAttributeName(propertyName);
        PropertyInfo pi = this.getProfileInfo().getPropertyInfo(propertyName);
        if (pi.getAccessMode().equals("read-only")) {
            throw new IdentityException("Property has read only access - cannot set: " + propertyName);
        }
        if (property != null && !pi.getType().equals(property.getClass().getName())) {
            throw new IdentityException("Wrong property type. Must be: " + pi.getType() + "; and found: " + property.getClass().getName());
        }
        if (attributeName == null) {
            log.error((Object)("Proper LDAP attribute mapping not found for such property name: " + propertyName));
            return;
        }
        LdapContext ldapContext = this.getConnectionContext().createInitialContext();
        try {
            BasicAttributes attrs = new BasicAttributes(true);
            BasicAttribute attr = new BasicAttribute(attributeName);
            attr.add(property);
            attrs.put(attr);
            ldapContext.modifyAttributes(ldapUser.getDn(), 2, (Attributes)attrs);
            this.fireUserProfileChangedEvent(user.getId(), user.getUserName(), propertyName, property);
        }
        catch (NamingException e) {
            throw new IdentityException("Cannot set user property value.", e);
        }
        finally {
            try {
                ldapContext.close();
            }
            catch (NamingException e) {
                throw new IdentityException("Failed to close LDAP connection", e);
            }
        }
    }

    public Map getProperties(User user) throws IdentityException, IllegalArgumentException {
        if (user == null) {
            throw new IllegalArgumentException("User cannot be null");
        }
        if (user instanceof CachedUserImpl) {
            try {
                user = this.getUserModule().findUserById(user.getId());
            }
            catch (NoSuchUserException e) {
                throw new IdentityException("Illegal state - cached user doesn't exist in identity store: ", e);
            }
        }
        LDAPUserImpl ldapUser = null;
        if (!(user instanceof LDAPUserImpl)) {
            throw new IllegalArgumentException("This UserProfileModule implementation support only LDAPUserImpl objects");
        }
        ldapUser = (LDAPUserImpl)user;
        HashMap<String, Object> propertyMap = new HashMap<String, Object>();
        LdapContext ldapContext = this.getConnectionContext().createInitialContext();
        try {
            Map mappings = this.resolveAttributesMappingMap();
            Set props = mappings.keySet();
            Attributes attrs = ldapContext.getAttributes(ldapUser.getDn());
            for (String name : props) {
                String attrName = (String)mappings.get(name);
                Attribute attr = attrs.get(attrName);
                if (attr != null) {
                    propertyMap.put(name, attr.get());
                    PropertyInfo pi = this.getProfileInfo().getPropertyInfo(name);
                    if (attr.get() == null || pi.getType().equals(attr.get().getClass().getName())) continue;
                    log.error((Object)("Error on processing property:" + name));
                    log.error((Object)("Wrong property type retreived from LDAP. Should be: " + pi.getType() + "; and found: " + attr.get().getClass().getName()));
                    continue;
                }
                log.error((Object)("No such attribute ('" + attrName + "') in entry: " + ldapUser.getDn()));
            }
        }
        catch (NamingException e) {
            throw new IdentityException("Cannot get user property value.", e);
        }
        finally {
            try {
                ldapContext.close();
            }
            catch (NamingException e) {
                throw new IdentityException("Failed to close LDAP connection", e);
            }
        }
        return Collections.unmodifiableMap(propertyMap);
    }

    private String resolveAttributeName(String propertyName) throws IdentityException {
        PropertyInfo pi = this.getProfileInfo().getPropertyInfo(propertyName);
        if (pi == null) {
            throw new IdentityException("Cannot find profile information about property: " + propertyName);
        }
        String mapping = pi.getMappingLDAPValue();
        if (mapping == null) {
            throw new IdentityException("This property is not mapped as LDAP attribute: " + propertyName);
        }
        return mapping;
    }

    private Map resolveAttributesMappingMap() throws IdentityException {
        Map infos = this.getProfileInfo().getPropertiesInfo();
        Set keys = infos.keySet();
        HashMap<String, String> mappings = new HashMap<String, String>();
        for (String key : keys) {
            PropertyInfo prop = (PropertyInfo)infos.get(key);
            if (!prop.isMappedLDAP()) continue;
            mappings.put(prop.getName(), prop.getMappingLDAPValue());
        }
        return mappings;
    }

    public ProfileInfo getProfileInfo() throws IdentityException {
        if (this.profileInfo == null) {
            UserProfileModule module = (UserProfileModule)this.getIdentityContext().getObject("UserProfile");
            if (module == this) {
                throw new IdentityException("ProfileInfo not accessible - check configuration");
            }
            this.setProfileInfo(module.getProfileInfo());
        }
        return this.profileInfo;
    }

    protected UserModule getUserModule() throws IdentityException {
        if (this.userModule == null) {
            try {
                this.userModule = (UserModule)this.getIdentityContext().getObject("User");
            }
            catch (ClassCastException e) {
                throw new IdentityException("Not supported object as part of the context - must be UserModule", e);
            }
        }
        return this.userModule;
    }
}

