/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.model.instance;

import java.security.Permission;
import java.util.Collection;
import java.util.StringTokenizer;
import javax.security.auth.Subject;
import org.jboss.portal.security.PortalPermission;
import org.jboss.portal.security.PortalPermissionCollection;
import org.jboss.portal.security.PortalSecurityException;
import org.jboss.portal.security.spi.provider.PermissionRepository;

public final class InstancePermission
extends PortalPermission {
    private static final long serialVersionUID = 8445291296726152562L;
    public static final String VIEW_ACTION = "view";
    public static final String CREATE_ACTION = "create";
    public static final String DESTROY_ACTION = "destroy";
    public static final String CUSTOMIZE_ACTION = "customize";
    public static final String ADMIN_ACTION = "admin";
    public static final int VIEW_MASK = 1;
    public static final int CREATE_MASK = 2;
    public static final int DESTROY_MASK = 4;
    public static final int CUSTOMIZE_MASK = 8;
    public static final int ADMIN_MASK = 15;
    private int mask;
    private String actions;
    public static final String PERMISSION_TYPE = "instance";
    private static final String[] ACTION_NAMES = new String[]{"view", "create", "destroy", "customize"};

    public InstancePermission(PortalPermissionCollection collection) {
        super("instancepermission", collection);
    }

    public InstancePermission(String uri, Collection actions) {
        super("instancepermission", uri);
        if (actions == null) {
            throw new IllegalArgumentException("Actions agurment cannot be null");
        }
        for (String action : actions) {
            this.addAction(action);
        }
    }

    public InstancePermission(String uri, int mask) {
        super("instancepermission", uri);
        this.mask = mask;
    }

    public InstancePermission(String uri, String actions) {
        super("instancepermission", uri);
        if (actions == null) {
            throw new IllegalArgumentException("Actions agurment cannot be null");
        }
        StringTokenizer tokenizer = new StringTokenizer(actions, ",");
        while (tokenizer.hasMoreTokens()) {
            String action = tokenizer.nextToken();
            this.addAction(action);
        }
    }

    private void addAction(String action) throws IllegalArgumentException {
        if (VIEW_ACTION.equals(action)) {
            this.mask |= 1;
        } else if (CREATE_ACTION.equals(action)) {
            this.mask |= 2;
        } else if (DESTROY_ACTION.equals(action)) {
            this.mask |= 4;
        } else if (CUSTOMIZE_ACTION.equals(action)) {
            this.mask |= 8;
        } else if (ADMIN_ACTION.equals(action)) {
            this.mask |= 0xF;
        } else {
            throw new IllegalArgumentException("Illegal action " + action);
        }
    }

    public boolean implies(PermissionRepository repository, Subject caller, String roleName, PortalPermission permission) throws PortalSecurityException {
        if (permission instanceof InstancePermission) {
            InstancePermission pp = (InstancePermission)permission;
            if (pp.isContainer()) {
                return false;
            }
            String uri = pp.getURI();
            PortalPermission loaded = repository.getPermission(roleName, uri);
            if (loaded != null && loaded.implies((Permission)((Object)pp))) {
                return true;
            }
        }
        return false;
    }

    public boolean implies(Permission permission) {
        InstancePermission that;
        if (permission instanceof InstancePermission && !this.isContainer() && !(that = (InstancePermission)((Object)permission)).isContainer() && that.uri.equals(this.uri)) {
            return (this.mask & that.mask) == that.mask;
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof InstancePermission) {
            InstancePermission that = (InstancePermission)((Object)obj);
            if (this.isContainer()) {
                return that.isContainer();
            }
            return this.mask == that.mask && this.uri.equals(that.uri);
        }
        return false;
    }

    public int hashCode() {
        if (this.isContainer()) {
            return 0;
        }
        return this.uri.hashCode() * 43 + this.mask;
    }

    public String getActions() {
        if (this.actions == null) {
            StringBuffer tmp = new StringBuffer();
            for (int i = 0; i < ACTION_NAMES.length; ++i) {
                int mask = 2 >> i;
                if ((this.mask & mask) != mask) continue;
                tmp.append(ACTION_NAMES[i]).append(',');
            }
            int length = tmp.length();
            if (length > 0) {
                tmp.setLength(length - 1);
            }
            this.actions = tmp.toString();
        }
        return this.actions;
    }

    public String getType() {
        return PERMISSION_TYPE;
    }
}

