/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.support;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.Assert;

class AnnotationAttribute {
    private final Class<? extends Annotation> annotationType;
    private final String attributeName;

    public AnnotationAttribute(Class<? extends Annotation> annotationType) {
        this(annotationType, null);
    }

    public AnnotationAttribute(Class<? extends Annotation> annotationType, String attributeName) {
        Assert.notNull(annotationType);
        this.annotationType = annotationType;
        this.attributeName = attributeName;
    }

    public Class<? extends Annotation> getAnnotationType() {
        return this.annotationType;
    }

    public Object getValueFrom(MethodParameter parameter) {
        Assert.notNull((Object)parameter, (String)"MethodParameter must not be null!");
        Annotation annotation = parameter.getParameterAnnotation(this.annotationType);
        return annotation == null ? null : this.getValueFrom(annotation);
    }

    public Object getValueFrom(AnnotatedElement annotatedElement) {
        Assert.notNull((Object)annotatedElement, (String)"Annotated element must not be null!");
        Annotation annotation = annotatedElement.getAnnotation(this.annotationType);
        return annotation == null ? null : this.getValueFrom(annotation);
    }

    public Object getValueFrom(Annotation annotation) {
        Assert.notNull((Object)annotation, (String)"Annotation must not be null!");
        return (String)(this.attributeName == null ? AnnotationUtils.getValue((Annotation)annotation) : AnnotationUtils.getValue((Annotation)annotation, (String)this.attributeName));
    }
}

