/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.common.invocation;

import org.jboss.portal.common.invocation.Interceptor;
import org.jboss.portal.common.invocation.InterceptorStack;
import org.jboss.portal.common.invocation.InvocationContext;
import org.jboss.portal.common.invocation.InvocationException;
import org.jboss.portal.common.invocation.InvocationHandler;
import org.jboss.portal.common.invocation.Scope;

public abstract class Invocation {
    public static final InterceptorStack EMPTY_STACK = new InterceptorStack(){

        public int getLength() {
            return 0;
        }

        public Interceptor getInterceptor(int index) throws ArrayIndexOutOfBoundsException {
            throw new ArrayIndexOutOfBoundsException();
        }
    };
    private int currentIndex = 0;
    private InterceptorStack currentStack = EMPTY_STACK;
    private InvocationHandler handler;

    public abstract InvocationContext getContext() throws IllegalStateException;

    public Object getAttribute(Scope attrScope, Object attrKey) throws IllegalArgumentException {
        return this.getContext().getAttribute(attrScope, attrKey);
    }

    public void setAttribute(Scope attrScope, Object attrKey, Object attrValue) throws IllegalArgumentException {
        this.getContext().setAttribute(attrScope, attrKey, attrValue);
    }

    public void removeAttribute(Scope attrScope, Object attrKey) throws IllegalArgumentException {
        this.getContext().removeAttribute(attrScope, attrKey);
    }

    public InvocationHandler getHandler() {
        return this.handler;
    }

    public void setHandler(InvocationHandler handler) {
        this.handler = handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invokeNext() throws Exception, InvocationException {
        if (this.currentIndex < this.currentStack.getLength()) {
            try {
                Interceptor interceptor = this.currentStack.getInterceptor(this.currentIndex++);
                if (interceptor == null) {
                    throw new InvocationException("Null interceptor at index=" + (this.currentIndex - 1));
                }
                Object object = interceptor.invoke(this);
                return object;
            }
            finally {
                --this.currentIndex;
            }
        }
        if (this.handler == null) {
            throw new InvocationException("No handler");
        }
        return this.handler.invoke(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(InterceptorStack newStack) throws Exception, InvocationException {
        if (newStack == null) {
            throw new InvocationException("Cannot invoke with a null interceptor[]");
        }
        InterceptorStack previousInterceptors = this.currentStack;
        int previousIndex = this.currentIndex;
        try {
            this.currentStack = newStack;
            this.currentIndex = 0;
            Object object = this.invokeNext();
            return object;
        }
        finally {
            this.currentStack = previousInterceptors;
            this.currentIndex = previousIndex;
        }
    }
}

