/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.search.federation.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.portal.jems.as.system.AbstractJBossService;
import org.jboss.portal.search.FederatedQuery;
import org.jboss.portal.search.FederatedSearcher;
import org.jboss.portal.search.Query;
import org.jboss.portal.search.QueryConversionException;
import org.jboss.portal.search.SearchingException;
import org.jboss.portal.search.federation.SearchFederation;
import org.jboss.portal.search.result.ResultSet;

public class SearchFederationService
extends AbstractJBossService
implements SearchFederation {
    private Map registry = new HashMap();

    public synchronized void register(FederatedSearcher federatedSearcher) {
        if (federatedSearcher == null) {
            throw new IllegalArgumentException("No null invoker");
        }
        String id = federatedSearcher.getId();
        if (this.registry.containsKey(id)) {
            throw new IllegalArgumentException("Attempting dual registration of " + id);
        }
        HashMap<String, FederatedSearcher> copy = new HashMap<String, FederatedSearcher>(this.registry);
        copy.put(id, federatedSearcher);
        this.registry = copy;
    }

    public synchronized void unregister(String id) {
        if (id == null) {
            throw new IllegalArgumentException("No null id accepted");
        }
        if (!this.registry.containsKey(id)) {
            throw new IllegalArgumentException("Attempting to unregister unknown federated search service " + id);
        }
        HashMap copy = new HashMap(this.registry);
        copy.remove(id);
        this.registry = copy;
    }

    public List getFederatedSearcherList() {
        return Collections.unmodifiableList(new ArrayList(this.registry.values()));
    }

    public FederatedSearcher getFederatedSearcher(String id) {
        return (FederatedSearcher)this.registry.get(id);
    }

    public List search(FederatedQuery query) throws SearchingException {
        ArrayList<ResultSet> results = new ArrayList<ResultSet>();
        for (FederatedSearcher searcher : this.registry.values()) {
            try {
                results.add(this.search(query, searcher));
            }
            catch (QueryConversionException e) {
                e.printStackTrace();
            }
        }
        return results;
    }

    public List search(FederatedQuery query, List searchers) throws SearchingException {
        ArrayList<ResultSet> results = new ArrayList<ResultSet>();
        for (String federatedId : searchers) {
            FederatedSearcher searcher = this.getFederatedSearcher(federatedId);
            if (searcher == null) {
                throw new SearchingException("Cannot find searcher: " + federatedId);
            }
            try {
                results.add(this.search(query, searcher));
            }
            catch (QueryConversionException e) {
                e.printStackTrace();
            }
        }
        return results;
    }

    private ResultSet search(FederatedQuery query, FederatedSearcher searcher) throws QueryConversionException, SearchingException {
        Query convertedQuery = null;
        convertedQuery = searcher.getQueryConverter().convert(query);
        return searcher.search(convertedQuery);
    }
}

