/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient.cookie;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.httpclient.cookie.CookieSpec;
import org.apache.commons.httpclient.cookie.CookieSpecBase;
import org.apache.commons.httpclient.cookie.NetscapeDraftSpec;
import org.apache.commons.httpclient.cookie.RFC2109Spec;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class CookiePolicy {
    private static Map SPECS = Collections.synchronizedMap(new HashMap());
    public static final String BROWSER_COMPATIBILITY = "compatibility";
    public static final String NETSCAPE = "netscape";
    public static final String RFC_2109 = "rfc2109";
    public static final String IGNORE_COOKIES = "ignoreCookies";
    public static final String DEFAULT = "default";
    public static final int COMPATIBILITY = 0;
    public static final int NETSCAPE_DRAFT = 1;
    public static final int RFC2109 = 2;
    private static int defaultPolicy;
    protected static final Log LOG;
    static /* synthetic */ Class class$org$apache$commons$httpclient$cookie$RFC2109Spec;
    static /* synthetic */ Class class$org$apache$commons$httpclient$cookie$CookieSpecBase;
    static /* synthetic */ Class class$org$apache$commons$httpclient$cookie$NetscapeDraftSpec;
    static /* synthetic */ Class class$org$apache$commons$httpclient$cookie$IgnoreCookiesSpec;
    static /* synthetic */ Class class$org$apache$commons$httpclient$cookie$CookiePolicy;

    public static void registerCookieSpec(String string, Class clazz) {
        if (string == null) {
            throw new IllegalArgumentException("Id may not be null");
        }
        if (clazz == null) {
            throw new IllegalArgumentException("Cookie spec class may not be null");
        }
        SPECS.put(string.toLowerCase(), clazz);
    }

    public static void unregisterCookieSpec(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Id may not be null");
        }
        SPECS.remove(string.toLowerCase());
    }

    public static CookieSpec getCookieSpec(String string) throws IllegalStateException {
        if (string == null) {
            throw new IllegalArgumentException("Id may not be null");
        }
        Class clazz = (Class)SPECS.get(string.toLowerCase());
        if (clazz != null) {
            try {
                return (CookieSpec)clazz.newInstance();
            }
            catch (Exception exception) {
                LOG.error((Object)("Error initializing cookie spec: " + string), (Throwable)exception);
                throw new IllegalStateException(string + " cookie spec implemented by " + clazz.getName() + " could not be initialized");
            }
        }
        throw new IllegalStateException("Unsupported cookie spec " + string);
    }

    public static int getDefaultPolicy() {
        return defaultPolicy;
    }

    public static void setDefaultPolicy(int n) {
        defaultPolicy = n;
    }

    public static CookieSpec getSpecByPolicy(int n) {
        switch (n) {
            case 0: {
                return new CookieSpecBase();
            }
            case 1: {
                return new NetscapeDraftSpec();
            }
            case 2: {
                return new RFC2109Spec();
            }
        }
        return CookiePolicy.getDefaultSpec();
    }

    public static CookieSpec getDefaultSpec() {
        try {
            return CookiePolicy.getCookieSpec(DEFAULT);
        }
        catch (IllegalStateException illegalStateException) {
            LOG.warn((Object)"Default cookie policy is not registered");
            return new RFC2109Spec();
        }
    }

    public static CookieSpec getSpecByVersion(int n) {
        switch (n) {
            case 0: {
                return new NetscapeDraftSpec();
            }
            case 1: {
                return new RFC2109Spec();
            }
        }
        return CookiePolicy.getDefaultSpec();
    }

    public static CookieSpec getCompatibilitySpec() {
        return CookiePolicy.getSpecByPolicy(0);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        CookiePolicy.registerCookieSpec(DEFAULT, class$org$apache$commons$httpclient$cookie$RFC2109Spec == null ? (class$org$apache$commons$httpclient$cookie$RFC2109Spec = CookiePolicy.class$("org.apache.commons.httpclient.cookie.RFC2109Spec")) : class$org$apache$commons$httpclient$cookie$RFC2109Spec);
        CookiePolicy.registerCookieSpec(RFC_2109, class$org$apache$commons$httpclient$cookie$RFC2109Spec == null ? (class$org$apache$commons$httpclient$cookie$RFC2109Spec = CookiePolicy.class$("org.apache.commons.httpclient.cookie.RFC2109Spec")) : class$org$apache$commons$httpclient$cookie$RFC2109Spec);
        CookiePolicy.registerCookieSpec(BROWSER_COMPATIBILITY, class$org$apache$commons$httpclient$cookie$CookieSpecBase == null ? (class$org$apache$commons$httpclient$cookie$CookieSpecBase = CookiePolicy.class$("org.apache.commons.httpclient.cookie.CookieSpecBase")) : class$org$apache$commons$httpclient$cookie$CookieSpecBase);
        CookiePolicy.registerCookieSpec(NETSCAPE, class$org$apache$commons$httpclient$cookie$NetscapeDraftSpec == null ? (class$org$apache$commons$httpclient$cookie$NetscapeDraftSpec = CookiePolicy.class$("org.apache.commons.httpclient.cookie.NetscapeDraftSpec")) : class$org$apache$commons$httpclient$cookie$NetscapeDraftSpec);
        CookiePolicy.registerCookieSpec(IGNORE_COOKIES, class$org$apache$commons$httpclient$cookie$IgnoreCookiesSpec == null ? (class$org$apache$commons$httpclient$cookie$IgnoreCookiesSpec = CookiePolicy.class$("org.apache.commons.httpclient.cookie.IgnoreCookiesSpec")) : class$org$apache$commons$httpclient$cookie$IgnoreCookiesSpec);
        defaultPolicy = 2;
        LOG = LogFactory.getLog((Class)(class$org$apache$commons$httpclient$cookie$CookiePolicy == null ? (class$org$apache$commons$httpclient$cookie$CookiePolicy = CookiePolicy.class$("org.apache.commons.httpclient.cookie.CookiePolicy")) : class$org$apache$commons$httpclient$cookie$CookiePolicy));
    }
}

