/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.portlet;

import java.util.Arrays;
import org.jboss.portal.common.util.ParameterValidation;
import org.jboss.portal.portlet.PortletContext;

public class StatefulPortletContext
extends PortletContext {
    private final byte[] marshalledState;

    StatefulPortletContext(String id, byte[] marshalledState) throws IllegalArgumentException {
        super(id);
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)marshalledState, (String)"Portlet state");
        this.marshalledState = marshalledState;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        StatefulPortletContext that = (StatefulPortletContext)o;
        return Arrays.equals(this.marshalledState, that.marshalledState);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.marshalledState != null ? this.marshalledState.hashCode() : 0);
        return result;
    }

    public byte[] getState() {
        return this.marshalledState;
    }

    public String toString() {
        return "StatefulPortletContext[" + this.id + "," + this.marshalledState.length + "]";
    }
}

