/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.portal.api.cms;

import org.osivia.portal.api.cms.UniversalID;
import org.osivia.portal.api.cms.UpdateScope;

public class UpdateInformations {
    private final UniversalID documentID;
    private final UniversalID spaceID;
    private final UpdateScope scope;
    private final String repository;
    private boolean async = false;

    public UpdateInformations(UniversalID documentID, UniversalID spaceID) {
        this(documentID, spaceID, UpdateScope.SCOPE_SPACE, false);
    }

    public UpdateInformations(String repository) {
        this(null, null, UpdateScope.SCOPE_REPOSITORY, false, repository);
    }

    public UpdateInformations(UniversalID documentID, UniversalID spaceID, UpdateScope scope, boolean async) {
        this(documentID, spaceID, scope, async, spaceID.getRepositoryName());
    }

    public UpdateInformations(UniversalID documentID, UniversalID spaceID, UpdateScope scope, boolean async, String repository) {
        this.documentID = documentID;
        this.spaceID = spaceID;
        this.async = async;
        this.scope = scope;
        this.repository = repository;
    }

    public boolean isAsync() {
        return this.async;
    }

    public UniversalID getDocumentID() {
        return this.documentID;
    }

    public UniversalID getSpaceID() {
        return this.spaceID;
    }

    public UpdateScope getScope() {
        return this.scope;
    }

    public String getRepository() {
        return this.repository;
    }
}

