/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.portal.api.locator;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.lang3.StringUtils;
import org.osivia.portal.api.locator.Locator;
import org.springframework.context.ApplicationContext;

public class LocatorInvocationHandler
implements InvocationHandler {
    private final String name;
    private final Class<?> requiredType;

    public LocatorInvocationHandler(String name, Class<?> requiredType) {
        this.name = name;
        this.requiredType = requiredType;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object result;
        ApplicationContext applicationContext = Locator.getApplicationContext();
        Object bean = StringUtils.isEmpty((CharSequence)this.name) ? applicationContext.getBean(this.requiredType) : applicationContext.getBean(this.name, this.requiredType);
        ClassLoader savedClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(bean.getClass().getClassLoader());
            result = method.invoke(bean, args);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() != null) {
                throw e.getCause();
            }
            throw e;
        }
        finally {
            Thread.currentThread().setContextClassLoader(savedClassLoader);
        }
        return result;
    }
}

