/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.portlet.context;

import java.util.Enumeration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletSession;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.AbstractRequestAttributes;
import org.springframework.web.context.request.DestructionCallbackBindingListener;
import org.springframework.web.portlet.util.PortletUtils;

public class PortletRequestAttributes
extends AbstractRequestAttributes {
    public static final String DESTRUCTION_CALLBACK_NAME_PREFIX = PortletRequestAttributes.class.getName() + ".DESTRUCTION_CALLBACK.";
    private final PortletRequest request;
    private PortletResponse response;
    private volatile PortletSession session;
    private final Map<String, Object> sessionAttributesToUpdate = new ConcurrentHashMap<String, Object>(1);
    private final Map<String, Object> globalSessionAttributesToUpdate = new ConcurrentHashMap<String, Object>(1);
    public static final int SCOPE_GLOBAL_SESSION = 2;

    public PortletRequestAttributes(PortletRequest request) {
        Assert.notNull((Object)request, (String)"Request must not be null");
        this.request = request;
    }

    public PortletRequestAttributes(PortletRequest request, PortletResponse response) {
        this(request);
        this.response = response;
    }

    public final PortletRequest getRequest() {
        return this.request;
    }

    public final PortletResponse getResponse() {
        return this.response;
    }

    protected final PortletSession getSession(boolean allowCreate) {
        if (this.isRequestActive()) {
            return this.request.getPortletSession(allowCreate);
        }
        if (this.session == null && allowCreate) {
            throw new IllegalStateException("No session found and request already completed - cannot create new session!");
        }
        return this.session;
    }

    public Object getAttribute(String name, int scope) {
        if (scope == 0) {
            if (!this.isRequestActive()) {
                throw new IllegalStateException("Cannot ask for request attribute - request is not active anymore!");
            }
            return this.request.getAttribute(name);
        }
        PortletSession session = this.getSession(false);
        if (session != null) {
            if (scope == 2) {
                Object value = session.getAttribute(name, 1);
                if (value != null) {
                    this.globalSessionAttributesToUpdate.put(name, value);
                }
                return value;
            }
            Object value = session.getAttribute(name);
            if (value != null) {
                this.sessionAttributesToUpdate.put(name, value);
            }
            return value;
        }
        return null;
    }

    public void setAttribute(String name, Object value, int scope) {
        if (scope == 0) {
            if (!this.isRequestActive()) {
                throw new IllegalStateException("Cannot set request attribute - request is not active anymore!");
            }
            this.request.setAttribute(name, value);
        } else {
            PortletSession session = this.getSession(true);
            if (scope == 2) {
                session.setAttribute(name, value, 1);
                this.globalSessionAttributesToUpdate.remove(name);
            } else {
                session.setAttribute(name, value);
                this.sessionAttributesToUpdate.remove(name);
            }
        }
    }

    public void removeAttribute(String name, int scope) {
        if (scope == 0) {
            if (this.isRequestActive()) {
                this.request.removeAttribute(name);
                this.removeRequestDestructionCallback(name);
            }
        } else {
            PortletSession session = this.getSession(false);
            if (session != null) {
                if (scope == 2) {
                    session.removeAttribute(name, 1);
                    this.globalSessionAttributesToUpdate.remove(name);
                } else {
                    session.removeAttribute(name);
                    this.sessionAttributesToUpdate.remove(name);
                }
            }
        }
    }

    public String[] getAttributeNames(int scope) {
        if (scope == 0) {
            if (!this.isRequestActive()) {
                throw new IllegalStateException("Cannot ask for request attributes - request is not active anymore!");
            }
            return StringUtils.toStringArray((Enumeration)this.request.getAttributeNames());
        }
        PortletSession session = this.getSession(false);
        if (session != null) {
            if (scope == 2) {
                return StringUtils.toStringArray((Enumeration)session.getAttributeNames(1));
            }
            return StringUtils.toStringArray((Enumeration)session.getAttributeNames());
        }
        return new String[0];
    }

    public void registerDestructionCallback(String name, Runnable callback, int scope) {
        if (scope == 0) {
            this.registerRequestDestructionCallback(name, callback);
        } else {
            this.registerSessionDestructionCallback(name, callback);
        }
    }

    public Object resolveReference(String key) {
        if ("request".equals(key)) {
            return this.request;
        }
        if ("session".equals(key)) {
            return this.getSession(true);
        }
        return null;
    }

    public String getSessionId() {
        return this.getSession(true).getId();
    }

    public Object getSessionMutex() {
        return PortletUtils.getSessionMutex(this.getSession(true));
    }

    protected void updateAccessedSessionAttributes() {
        this.session = this.request.getPortletSession(false);
        if (this.session != null) {
            try {
                Object oldValue;
                Object newValue;
                String name;
                for (Map.Entry<String, Object> entry : this.sessionAttributesToUpdate.entrySet()) {
                    name = entry.getKey();
                    newValue = entry.getValue();
                    oldValue = this.session.getAttribute(name);
                    if (oldValue != newValue) continue;
                    this.session.setAttribute(name, newValue);
                }
                for (Map.Entry<String, Object> entry : this.globalSessionAttributesToUpdate.entrySet()) {
                    name = entry.getKey();
                    newValue = entry.getValue();
                    oldValue = this.session.getAttribute(name, 1);
                    if (oldValue != newValue) continue;
                    this.session.setAttribute(name, newValue, 1);
                }
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        this.sessionAttributesToUpdate.clear();
        this.globalSessionAttributesToUpdate.clear();
    }

    protected void registerSessionDestructionCallback(String name, Runnable callback) {
        PortletSession session = this.getSession(true);
        session.setAttribute(DESTRUCTION_CALLBACK_NAME_PREFIX + name, (Object)new DestructionCallbackBindingListener(callback));
    }

    public String toString() {
        return this.request.toString();
    }
}

