/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.theme.impl.render.div;

import java.io.PrintWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.portal.Mode;
import org.jboss.portal.WindowState;
import org.jboss.portal.theme.render.AbstractObjectRenderer;
import org.jboss.portal.theme.render.RenderException;
import org.jboss.portal.theme.render.RendererContext;
import org.jboss.portal.theme.render.renderer.ActionRendererContext;
import org.jboss.portal.theme.render.renderer.DecorationRenderer;
import org.jboss.portal.theme.render.renderer.DecorationRendererContext;

public class DivDecorationRenderer
extends AbstractObjectRenderer
implements DecorationRenderer {
    @Override
    public void render(RendererContext rendererContext, DecorationRendererContext drc) throws RenderException {
        PrintWriter markup = rendererContext.getWriter();
        DivDecorationRenderer.renderTitle(rendererContext, drc);
        markup.print("<div class=\"portlet-mode-container\">");
        DivDecorationRenderer.renderTriggerableActions(rendererContext, drc, "mode");
        DivDecorationRenderer.renderTriggerableActions(rendererContext, drc, "windowstate");
        markup.print("</div>");
    }

    private static void renderTitle(RendererContext ctx, DecorationRendererContext drc) {
        PrintWriter out = ctx.getWriter();
        out.print("<div class=\"portlet-titlebar-decoration\"></div>");
        out.print("<span class=\"portlet-titlebar-title\">");
        out.print(drc.getTitle());
        out.print("</span>");
    }

    private static void renderTriggerableActions(RendererContext ctx, DecorationRendererContext drc, String selector) {
        Collection modesOrStates = drc.getTriggerableActions(selector);
        if (modesOrStates == null) {
            return;
        }
        if (modesOrStates instanceof List) {
            List list = (List)modesOrStates;
            Collections.sort(list, new ModeAndStateComparator());
            modesOrStates = list;
        }
        for (ActionRendererContext action : modesOrStates) {
            if (!action.isEnabled()) continue;
            PrintWriter out = ctx.getWriter();
            out.print("<span class=\"mode-button\" title=\"");
            out.print(action.getName());
            out.print("\"><a class=\"portlet-mode-");
            out.print(action.getName());
            out.print("\" href=\"");
            out.print(action.getURL());
            out.print("\">&nbsp;</a></span>");
        }
    }

    private static class ModeAndStateComparator
    implements Comparator {
        private final Map modeOrState2Index = new HashMap();
        private int lastModeIndex = 1;
        private int lastStateIndex = 101;

        public ModeAndStateComparator() {
            this.modeOrState2Index.put(Mode.EDIT.toString(), new Integer(97));
            this.modeOrState2Index.put(Mode.HELP.toString(), new Integer(98));
            this.modeOrState2Index.put(Mode.VIEW.toString(), new Integer(99));
            this.modeOrState2Index.put(Mode.ADMIN.toString(), new Integer(100));
            this.modeOrState2Index.put(WindowState.MINIMIZED.toString(), new Integer(198));
            this.modeOrState2Index.put(WindowState.NORMAL.toString(), new Integer(199));
            this.modeOrState2Index.put(WindowState.MAXIMIZED.toString(), new Integer(200));
        }

        public int compare(Object o1, Object o2) {
            ActionRendererContext action1 = (ActionRendererContext)o1;
            ActionRendererContext action2 = (ActionRendererContext)o2;
            String origin1 = action1.getName();
            String origin2 = action2.getName();
            int index1 = this.getIndexFor(origin1);
            int index2 = this.getIndexFor(origin2);
            return index1 - index2;
        }

        private int getIndexFor(Object origin) {
            Integer index = (Integer)this.modeOrState2Index.get(origin);
            if (index == null) {
                Integer n;
                if (origin instanceof Mode) {
                    int n2 = this.lastModeIndex++;
                    n = new Integer(n2);
                } else {
                    int n3 = this.lastStateIndex++;
                    n = new Integer(n3);
                }
                index = n;
                this.modeOrState2Index.put(origin, index);
            }
            return index;
        }
    }
}

