/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.theme.page;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jboss.portal.theme.page.Region;
import org.jboss.portal.theme.page.WindowContext;
import org.jboss.portal.theme.render.renderer.PageRendererContext;
import org.jboss.portal.theme.render.renderer.RegionRendererContext;
import org.jboss.portal.theme.render.renderer.WindowRendererContext;

public class PageResult
implements PageRendererContext {
    protected final Map results;
    protected final Map windowContexts;
    protected String pageName;
    protected Map properties;
    protected String layoutState;
    final Map regions;

    public PageResult(String pageName, Map properties) {
        this.pageName = pageName;
        this.properties = properties == null ? new HashMap() : properties;
        this.results = new HashMap(5);
        this.windowContexts = new HashMap(5);
        this.regions = new HashMap(5);
    }

    public PageResult(String pageName) {
        this(pageName, new HashMap());
    }

    public Region getRegion2(String regionName) {
        return (Region)this.regions.get(regionName);
    }

    public String getPageName() {
        return this.pageName;
    }

    public String getLayoutState() {
        return this.layoutState;
    }

    public void setLayoutState(String layoutState) {
        this.layoutState = layoutState;
    }

    public Set getWindowIds() {
        return this.windowContexts.keySet();
    }

    @Override
    public WindowRendererContext getWindow(String windowId) {
        return this.getWindowContext(windowId);
    }

    public WindowContext getWindowContext(String windowId) {
        return (WindowContext)this.windowContexts.get(windowId);
    }

    public Map getWindowContextMap() {
        return this.windowContexts;
    }

    public void addWindowContext(WindowContext windowContext) {
        this.windowContexts.put(windowContext.getId(), windowContext);
        Region region = (Region)this.regions.get(windowContext.getRegionName());
        if (region == null) {
            region = new Region(this, windowContext.getRegionName());
            this.regions.put(region.getId(), region);
        }
        region.addWindowContext(windowContext);
    }

    @Override
    public String getProperty(String name) {
        return (String)this.properties.get(name);
    }

    @Override
    public Map getProperties() {
        return this.properties;
    }

    @Override
    public Collection getRegions() {
        return this.regions.values();
    }

    @Override
    public RegionRendererContext getRegion(String regionName) {
        return (RegionRendererContext)this.regions.get(regionName);
    }

    public void rebuild() {
        for (Region region : this.regions.values()) {
            region.windows.clear();
        }
        for (WindowContext wc : this.windowContexts.values()) {
            Region region = (Region)this.regions.get(wc.getRegionName());
            if (region == null) {
                region = new Region(this, wc.getRegionName());
                this.regions.put(region.getId(), region);
            }
            region.addWindowContext(wc);
        }
    }
}

