/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.portal.taglib.portal.tag;

import java.io.IOException;
import java.io.Writer;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.SimpleTagSupport;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.dom4j.Element;
import org.dom4j.io.HTMLWriter;
import org.osivia.portal.api.html.DOM4JUtils;
import org.osivia.portal.api.internationalization.Bundle;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.portal.api.internationalization.IInternationalizationService;
import org.osivia.portal.api.locator.Locator;

public class FormatRelativeDateTag
extends SimpleTagSupport {
    private Date value;
    private boolean tooltip = true;
    private boolean capitalize;
    private final IBundleFactory bundleFactory;

    public FormatRelativeDateTag() {
        IInternationalizationService internationalizationService = (IInternationalizationService)Locator.getService((String)"osivia:service=InternationalizationService", IInternationalizationService.class);
        this.bundleFactory = internationalizationService.getBundleFactory(Thread.currentThread().getContextClassLoader());
    }

    public void doTag() throws JspException, IOException {
        PageContext pageContext = (PageContext)this.getJspContext();
        Locale locale = pageContext.getRequest().getLocale();
        Bundle bundle = this.bundleFactory.getBundle(locale);
        if (this.value != null) {
            Element container;
            String key;
            Date currentDate = new Date();
            Calendar currentCalendar = DateUtils.toCalendar((Date)currentDate);
            Integer[] fields = new Integer[]{1, 2, 3, 6, 11, 12};
            Integer currentField = null;
            int amount = 0;
            for (Integer field : fields) {
                Calendar calendar = DateUtils.toCalendar((Date)this.value);
                calendar.add(field, 1);
                if (!calendar.before(currentCalendar)) continue;
                currentField = field;
                while (calendar.before(currentCalendar)) {
                    calendar.add(field, 1);
                    ++amount;
                }
                break;
            }
            if (currentField == null) {
                key = "RELATIVE_DATE_JUST_NOW";
            } else {
                String fragment;
                switch (currentField) {
                    case 1: {
                        fragment = "YEAR";
                        break;
                    }
                    case 2: {
                        fragment = "MONTH";
                        break;
                    }
                    case 3: {
                        fragment = "WEEK";
                        break;
                    }
                    case 6: {
                        fragment = "DAY";
                        break;
                    }
                    case 11: {
                        fragment = "HOUR";
                        break;
                    }
                    case 12: {
                        fragment = "MINUTE";
                        break;
                    }
                    default: {
                        fragment = null;
                    }
                }
                key = fragment == null ? "RELATIVE_DATE_JUST_NOW" : (amount == 1 ? "RELATIVE_DATE_ONE_" + fragment + "_AGO" : "RELATIVE_DATE_N_" + fragment + "S_AGO");
            }
            String text = bundle.getString(key, new Object[]{amount});
            if (this.capitalize) {
                text = StringUtils.capitalize((String)text);
            }
            if (this.tooltip) {
                container = DOM4JUtils.generateElement((String)"abbr", null, (String)text);
                DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 3, locale);
                DOM4JUtils.addAttribute((Element)container, (String)"title", (String)dateFormat.format(this.value));
            } else {
                container = DOM4JUtils.generateElement((String)"span", null, (String)text);
            }
            HTMLWriter htmlWriter = new HTMLWriter((Writer)this.getJspContext().getOut());
            htmlWriter.setEscapeText(false);
            htmlWriter.write(container);
        }
    }

    public void setValue(Date value) {
        this.value = value;
    }

    public void setTooltip(boolean tooltip) {
        this.tooltip = tooltip;
    }

    public void setCapitalize(boolean capitalize) {
        this.capitalize = capitalize;
    }
}

