/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.portal.api.cms.repository;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.osivia.portal.api.cms.CMSPortalControllerContext;
import org.osivia.portal.api.cms.UpdateInformations;
import org.osivia.portal.api.cms.exception.CMSException;
import org.osivia.portal.api.cms.exception.DocumentForbiddenException;
import org.osivia.portal.api.cms.model.Document;
import org.osivia.portal.api.cms.model.NavigationItem;
import org.osivia.portal.api.cms.model.Personnalization;
import org.osivia.portal.api.cms.repository.RepositoryFactory;
import org.osivia.portal.api.cms.repository.UserRepository;
import org.osivia.portal.api.cms.repository.UserStorage;
import org.osivia.portal.api.cms.repository.cache.SharedRepository;
import org.osivia.portal.api.cms.repository.cache.SharedRepositoryKey;
import org.osivia.portal.api.cms.repository.model.shared.RepositoryDocument;
import org.osivia.portal.api.cms.repository.model.user.NavigationItemImpl;
import org.osivia.portal.api.cms.service.RepositoryListener;
import org.osivia.portal.api.cms.service.SpaceCacheBean;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.directory.v2.DirServiceFactory;
import org.osivia.portal.api.directory.v2.service.GroupService;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.core.imports.IPortalImportManager;

public abstract class BaseUserRepository
implements UserRepository {
    private static final String OSIVIA_REPOSITORY_ADMINISTRATOR = "osivia.repository.administrator.";
    public static String SESSION_ATTRIBUTE_NAME = "osivia.CMSUserRepository";
    public static String SUPERUSER_NAME = "superuser";
    protected SharedRepositoryKey repositoryKey;
    protected List<RepositoryListener> listeners;
    protected BaseUserRepository publishRepository;
    private boolean previewRepository = false;
    private String userName = null;
    protected boolean batchMode = false;
    UserStorage userStorage;
    public ThreadLocal<CMSPortalControllerContext> portalCtx = new ThreadLocal();
    private RepositoryFactory repositoryFactory;
    private GroupService groupService;

    public GroupService getGroupService() {
        if (this.groupService == null) {
            this.groupService = (GroupService)DirServiceFactory.getService(GroupService.class);
        }
        return this.groupService;
    }

    public BaseUserRepository(RepositoryFactory repositoryFactory, SharedRepositoryKey repositoryKey, BaseUserRepository publishRepository, String userName, UserStorage userStorage) {
        this.repositoryKey = repositoryKey;
        this.listeners = new ArrayList<RepositoryListener>();
        if (publishRepository != null) {
            this.publishRepository = publishRepository;
            this.previewRepository = true;
        }
        this.userName = userName;
        this.userStorage = userStorage;
        userStorage.setUserRepository(this);
        this.repositoryFactory = repositoryFactory;
        this.init(repositoryKey);
    }

    public SharedRepositoryKey getRepositoryKey() {
        return this.repositoryKey;
    }

    public String getUserName() {
        return this.userName;
    }

    public Principal getPrincipal() {
        Principal principal = null;
        PortalControllerContext ctx = this.portalCtx.get().getPortalControllerContext();
        if (ctx.getHttpServletRequest() != null) {
            principal = ctx.getHttpServletRequest().getUserPrincipal();
        }
        return principal;
    }

    @Override
    public boolean isManager() {
        if (this.isAdministrator()) {
            return true;
        }
        Boolean repositoryAdministrator = Boolean.FALSE;
        PortalControllerContext ctx = this.portalCtx.get().getPortalControllerContext();
        if (ctx.getHttpServletRequest() != null && (repositoryAdministrator = (Boolean)ctx.getHttpServletRequest().getSession().getAttribute(this.getRepositoryAdministratorKey())) == null) {
            String profile;
            HttpServletRequest request = ctx.getHttpServletRequest();
            repositoryAdministrator = Boolean.FALSE;
            if (StringUtils.isNotEmpty((CharSequence)this.getRepositoryName()) && StringUtils.isNotEmpty((CharSequence)(profile = System.getProperty("osivia.cms.repository." + this.getRepositoryName() + ".administrators.profile"))) && request.isUserInRole(profile)) {
                repositoryAdministrator = Boolean.TRUE;
            }
            ctx.getHttpServletRequest().getSession().setAttribute(this.getRepositoryAdministratorKey(), (Object)repositoryAdministrator);
        }
        return repositoryAdministrator;
    }

    private String getRepositoryAdministratorKey() {
        return OSIVIA_REPOSITORY_ADMINISTRATOR + this.getUserName() + "." + this.getRepositoryName();
    }

    public boolean isAdministrator() {
        PortalControllerContext ctx = this.portalCtx.get().getPortalControllerContext();
        if (ctx.getHttpServletRequest() != null && ctx.getHttpServletRequest().getUserPrincipal() != null) {
            Boolean isAdministrator = (Boolean)ctx.getHttpServletRequest().getSession().getAttribute("osivia.isAdmin");
            if (isAdministrator == null) {
                isAdministrator = ctx.getHttpServletRequest().isUserInRole("Administrators");
                ctx.getHttpServletRequest().getSession().setAttribute("osivia.isAdmin", (Object)isAdministrator);
            }
            return isAdministrator;
        }
        return false;
    }

    @Override
    public void setPortalContext(CMSPortalControllerContext portalContext) {
        this.portalCtx.set(portalContext);
    }

    public PortalControllerContext getPortalContext() {
        return this.portalCtx.get().getPortalControllerContext();
    }

    public boolean isUserRefreshingPage() {
        return this.portalCtx.get().isUserRefreshingPage();
    }

    @Override
    public void addListener(RepositoryListener listener) {
        this.getSharedRepository().addListener(listener);
    }

    @Override
    public void removeListener(RepositoryListener listener) {
        this.getSharedRepository().removeListener(listener);
    }

    public boolean isPreviewRepository() {
        return this.previewRepository;
    }

    private void init(SharedRepositoryKey repositoryKey) {
        boolean initRepository = false;
        if (this.getSharedRepository() == null) {
            this.repositoryFactory.getSharedRepositories().put(repositoryKey, new SharedRepository(repositoryKey.getRepositoryName(), this.userStorage));
            initRepository = true;
        }
        if (initRepository) {
            this.startInitBatch();
        }
    }

    public void startInitBatch() {
        IPortalImportManager portalImportManager = (IPortalImportManager)Locator.getService(IPortalImportManager.class);
        portalImportManager.stopRequests();
        this.clearCaches();
        this.batchMode = true;
        this.getSharedRepository().beginBatch(this.userStorage);
        boolean error = false;
        try {
            this.initDocuments();
        }
        catch (Exception e) {
            this.userStorage.handleError();
            error = true;
            throw e;
        }
        finally {
            this.getSharedRepository().endBatch(this.userStorage);
            if (!error) {
                UpdateInformations infos = new UpdateInformations(this.getRepositoryName());
                try {
                    this.getSharedRepository().notifyUpdate(this.getUserStorage(), infos);
                }
                catch (CMSException e) {
                    throw new RuntimeException((Throwable)((Object)e));
                }
            }
            this.batchMode = false;
            portalImportManager.restartRequests();
        }
    }

    protected abstract void initDocuments();

    public String getRepositoryName() {
        return this.repositoryKey.getRepositoryName();
    }

    public SharedRepository getSharedRepository() {
        return this.repositoryFactory.getSharedRepositories().get(this.repositoryKey);
    }

    public RepositoryDocument getSharedDocument(String internalId) throws CMSException {
        return this.getSharedRepository().getDocument(this.getUserStorage(), internalId);
    }

    @Override
    public Document getDocument(String internalId) throws CMSException {
        RepositoryDocument sharedDocument;
        if (this.isUserRefreshingPage()) {
            this.reload(internalId);
        }
        if (this.checkSecurity(sharedDocument = this.getSharedRepository().getDocument(this.getUserStorage(), internalId))) {
            return sharedDocument;
        }
        throw new DocumentForbiddenException();
    }

    @Override
    public void reload(String internalId) throws CMSException {
        this.getSharedRepository().reload(this.getUserStorage(), internalId);
    }

    @Override
    public Personnalization getPersonnalization(String internalId) throws CMSException {
        return this.userStorage.getUserData(internalId);
    }

    @Override
    public NavigationItem getNavigationItem(String internalId) throws CMSException {
        RepositoryDocument document = this.getSharedDocument(internalId);
        if (!document.isNavigable()) {
            document = this.getNavigationParent(document);
        }
        return new NavigationItemImpl(this, document);
    }

    private boolean checkSecurity(RepositoryDocument document) {
        try {
            this.getPersonnalization(document.getInternalID());
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public RepositoryDocument getNavigationParent(RepositoryDocument document) throws CMSException {
        RepositoryDocument docImpl = document;
        RepositoryDocument parent = null;
        do {
            RepositoryDocument parentTmp;
            if (this.checkSecurity(parentTmp = this.getSharedDocument(docImpl.getParentInternalId()))) {
                parent = parentTmp;
                continue;
            }
            docImpl = parentTmp;
        } while (parent == null);
        return parent;
    }

    public List<RepositoryDocument> getNavigationChildren(RepositoryDocument document) throws CMSException {
        RepositoryDocument docImpl = document;
        List<String> childrenId = docImpl.getChildrenId();
        ArrayList<RepositoryDocument> children = new ArrayList<RepositoryDocument>();
        for (String id : childrenId) {
            RepositoryDocument sharedDocument = this.getSharedDocument(id);
            if (!sharedDocument.isNavigable() || !this.checkSecurity(sharedDocument)) continue;
            children.add(sharedDocument);
        }
        return children;
    }

    @Override
    public List<Locale> getLocales() {
        return Arrays.asList(Locale.FRENCH);
    }

    public UserStorage getUserStorage() {
        return this.userStorage;
    }

    @Override
    public void notifyUpdate(UpdateInformations infos) throws CMSException {
        this.getSharedRepository().notifyUpdate(this.getUserStorage(), infos);
    }

    @Override
    public void handleUpdate(UpdateInformations infos) throws CMSException {
        this.getSharedRepository().handleUpdate(this, this.getUserStorage(), infos);
    }

    public void clearCaches() {
        this.getSharedRepository().clear();
        if (this.publishRepository != null) {
            this.publishRepository.clearCaches();
        }
    }

    @Override
    public SpaceCacheBean getSpaceCacheInformations(String id) throws CMSException {
        return this.getSharedRepository().getSpaceCacheInformations(id);
    }
}

