/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.portal.api.cms.repository.model.shared;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.SerializationUtils;
import org.nuxeo.ecm.automation.client.model.NxDocumentMock;
import org.osivia.portal.api.cms.model.Document;
import org.osivia.portal.api.cms.repository.BaseUserRepository;
import org.osivia.portal.api.cms.repository.model.shared.RepositoryDocument;

public class MemoryRepositoryDocument
extends RepositoryDocument
implements Document,
Serializable {
    private List<String> acls = new ArrayList<String>();
    private List<String> computedAcls = new ArrayList<String>();

    public MemoryRepositoryDocument(BaseUserRepository userRepository, String type, String internalID, String name, String parentId, String spaceId, List<String> childrenId, Map<String, Object> properties) {
        super(userRepository, MemoryRepositoryDocument.buildNativeItem(type, name, properties), internalID, name, parentId, spaceId, childrenId, properties);
    }

    private static NxDocumentMock buildNativeItem(String type, String name, Map<String, Object> properties) {
        NxDocumentMock nativeItem = new NxDocumentMock();
        nativeItem.setName(name);
        nativeItem.setTitle(properties.get("dc:title").toString());
        nativeItem.setType(type);
        return nativeItem;
    }

    @Override
    public MemoryRepositoryDocument duplicateForPublication(String parentInternalId, List<String> childrenId, BaseUserRepository userRepository) throws CloneNotSupportedException {
        MemoryRepositoryDocument newDoc = (MemoryRepositoryDocument)SerializationUtils.clone((Serializable)this);
        newDoc.parentInternalId = parentInternalId;
        newDoc.childrenId = childrenId;
        newDoc.userRepository = userRepository;
        return newDoc;
    }

    @Override
    public MemoryRepositoryDocument duplicate() throws CloneNotSupportedException {
        MemoryRepositoryDocument newDoc = (MemoryRepositoryDocument)SerializationUtils.clone((Serializable)this);
        newDoc.parentInternalId = this.getParentInternalId();
        newDoc.childrenId = this.getChildrenId();
        newDoc.userRepository = this.userRepository;
        newDoc.preview = this.isPreview();
        return newDoc;
    }

    @Override
    public String getTitle() {
        return (String)this.getProperties().get("dc:title");
    }

    @Override
    public void setTitle(String title) {
        this.getProperties().put("dc:title", title);
    }

    public void setACL(List<String> acls) {
        this.acls = acls;
    }

    public List<String> getACL() {
        return this.acls;
    }

    public List<String> getComputedAcls() {
        return this.computedAcls;
    }

    public void setComputedAcls(List<String> computedAcls) {
        this.computedAcls = computedAcls;
    }
}

