/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.portal.kernel.tomcat;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Container;
import org.apache.catalina.ContainerEvent;
import org.apache.catalina.ContainerListener;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.core.StandardContext;
import org.jboss.portal.web.RequestDispatchCallback;
import org.jboss.portal.web.command.CommandDispatcher;
import org.jboss.portal.web.impl.DefaultServletContainerFactory;
import org.jboss.portal.web.spi.ServletContainerContext;
import org.jboss.portal.web.spi.WebAppContext;
import org.osivia.portal.kernel.tomcat.OrderedContextComparator;
import org.osivia.portal.kernel.tomcat.TomcatWebAppContext;

public class TomcatServletContainerContext
implements ServletContainerContext,
ContainerListener,
LifecycleListener {
    private final Engine engine;
    private final CommandDispatcher dispatcher;
    private final Set<String> monitoredHosts;
    private final Set<String> monitoredContexts;
    private ServletContainerContext.Registration registration;
    private OrderedContextComparator contextComparator = new OrderedContextComparator("/", "");

    public TomcatServletContainerContext(Engine engine) {
        this.engine = engine;
        this.dispatcher = new CommandDispatcher();
        this.monitoredHosts = new HashSet<String>();
        this.monitoredContexts = new HashSet<String>();
    }

    public Object include(ServletContext targetServletContext, HttpServletRequest request, HttpServletResponse response, RequestDispatchCallback callback, Object handback) throws ServletException, IOException {
        return this.dispatcher.include(targetServletContext, request, response, callback, handback);
    }

    public void setCallback(ServletContainerContext.Registration registration) {
        this.registration = registration;
    }

    public void unsetCallback(ServletContainerContext.Registration registration) {
        this.registration = null;
    }

    public void lifecycleEvent(LifecycleEvent event) {
        Object source = event.getSource();
        if (source instanceof Context) {
            Context context = (Context)source;
            if ("after_start".equals(event.getType())) {
                this.start(context);
            } else if ("before_stop".equals(event.getType())) {
                this.stop(context);
            }
        }
    }

    public synchronized void containerEvent(ContainerEvent event) {
        if (event.getData() instanceof Host) {
            Host host = (Host)event.getData();
            if ("addChild".equals(event.getType())) {
                this.registerHost(host);
            } else if ("removeChild".equals(event.getType())) {
                this.unregisterHost(host);
            }
        } else if (event.getData() instanceof StandardContext) {
            StandardContext context = (StandardContext)event.getData();
            if ("addChild".equals(event.getType())) {
                this.registerContext(context);
            } else if ("removeChild".equals(event.getType())) {
                this.unregisterContext(context);
            }
        }
    }

    public void start() {
        Container[] childrenContainers;
        DefaultServletContainerFactory.registerContext((ServletContainerContext)this);
        for (Container childContainer : childrenContainers = this.engine.findChildren()) {
            if (!(childContainer instanceof Host)) continue;
            Host host = (Host)childContainer;
            this.registerHost(host);
        }
        this.engine.addContainerListener((ContainerListener)this);
    }

    public void stop() {
        Container[] childrenContainers;
        this.engine.removeContainerListener((ContainerListener)this);
        for (Container childContainer : childrenContainers = this.engine.findChildren()) {
            if (!(childContainer instanceof Host)) continue;
            Host host = (Host)childContainer;
            this.unregisterHost(host);
        }
        this.registration.cancel();
        this.registration = null;
    }

    private void registerHost(Host host) {
        if (!this.monitoredHosts.contains(host.getName())) {
            Container[] childrenContainers = host.findChildren();
            Arrays.sort(childrenContainers, this.contextComparator);
            for (Container childContainer : childrenContainers) {
                if (!(childContainer instanceof StandardContext)) continue;
                StandardContext context = (StandardContext)childContainer;
                this.registerContext(context);
            }
            host.addContainerListener((ContainerListener)this);
            this.monitoredHosts.add(host.getName());
        }
    }

    private void unregisterHost(Host host) {
        if (this.monitoredHosts.contains(host.getName())) {
            Container[] childrenContainers;
            this.monitoredHosts.remove(host.getName());
            host.removeContainerListener((ContainerListener)this);
            for (Container childContainer : childrenContainers = host.findChildren()) {
                if (!(childContainer instanceof StandardContext)) continue;
                StandardContext context = (StandardContext)childContainer;
                this.unregisterContext(context);
            }
        }
    }

    private void registerContext(StandardContext context) {
        if (!this.monitoredContexts.contains(context.getName())) {
            context.addLifecycleListener((LifecycleListener)this);
            if (LifecycleState.STARTED.equals((Object)context.getState())) {
                this.start((Context)context);
            }
            this.monitoredContexts.add(context.getName());
        }
    }

    private void unregisterContext(StandardContext context) {
        if (this.monitoredContexts.contains(context.getName())) {
            this.monitoredContexts.remove(context.getName());
            if (LifecycleState.STARTED.equals((Object)context.getState())) {
                this.stop((Context)context);
            }
            context.removeLifecycleListener((LifecycleListener)this);
        }
    }

    private void start(Context context) {
        if (this.registration != null) {
            TomcatWebAppContext webAppContext = new TomcatWebAppContext(context);
            this.registration.registerWebApp((WebAppContext)webAppContext);
        }
    }

    private void stop(Context context) {
        if (this.registration != null) {
            this.registration.unregisterWebApp(context.getPath());
        }
    }
}

