/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.firstconnection.portlet.controller;

import java.io.IOException;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.commons.lang.StringUtils;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.services.firstconnection.portlet.model.UserForm;
import org.osivia.services.firstconnection.portlet.model.validator.UserFormValidator;
import org.osivia.services.firstconnection.portlet.service.FirstConnectionService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Validator;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.portlet.bind.PortletRequestDataBinder;
import org.springframework.web.portlet.bind.annotation.ActionMapping;
import org.springframework.web.portlet.bind.annotation.RenderMapping;
import org.springframework.web.portlet.context.PortletContextAware;

@Controller
@RequestMapping(value={"VIEW"})
public class FirstConnectionController
implements PortletContextAware {
    @Autowired
    private FirstConnectionService service;
    @Autowired
    private UserFormValidator userFormValidator;
    private PortletContext portletContext;

    @RenderMapping
    public String view(RenderRequest request, RenderResponse response) {
        return "view";
    }

    @ActionMapping(value="save")
    public void save(ActionRequest request, ActionResponse response, @ModelAttribute(value="userForm") @Validated UserForm form, BindingResult result) throws PortletException, IOException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        if (!result.hasErrors()) {
            this.service.save(portalControllerContext, form);
            String redirectionUrl = this.service.getRedirectionUrl(portalControllerContext);
            if (StringUtils.isNotEmpty((String)redirectionUrl)) {
                response.sendRedirect(redirectionUrl);
            }
        }
    }

    @ModelAttribute(value="userForm")
    public UserForm getUserForm(PortletRequest request, PortletResponse response) throws PortletException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, request, response);
        return this.service.getUserForm(portalControllerContext);
    }

    @InitBinder(value={"userForm"})
    public void invitationsCreationFormInitBinder(PortletRequestDataBinder binder) {
        binder.setDisallowedFields(new String[]{"id", "email"});
        binder.addValidators(new Validator[]{this.userFormValidator});
    }

    public void setPortletContext(PortletContext portletContext) {
        this.portletContext = portletContext;
    }
}

