/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.firstconnection.portlet.model.validator;

import org.apache.commons.lang.StringUtils;
import org.osivia.services.firstconnection.portlet.model.UserForm;
import org.springframework.stereotype.Component;
import org.springframework.validation.Errors;
import org.springframework.validation.ValidationUtils;
import org.springframework.validation.Validator;

@Component
public class UserFormValidator
implements Validator {
    private static final int PASSWORD_MIN_LENGTH = 6;

    public boolean supports(Class<?> clazz) {
        return UserForm.class.isAssignableFrom(clazz);
    }

    public void validate(Object target, Errors errors) {
        ValidationUtils.rejectIfEmpty((Errors)errors, (String)"firstName", (String)"NotEmpty");
        ValidationUtils.rejectIfEmpty((Errors)errors, (String)"lastName", (String)"NotEmpty");
        ValidationUtils.rejectIfEmpty((Errors)errors, (String)"password", (String)"NotEmpty");
        ValidationUtils.rejectIfEmpty((Errors)errors, (String)"passwordConfirmation", (String)"NotEmpty");
        UserForm form = (UserForm)target;
        if (StringUtils.isNotEmpty((String)form.getPassword()) && form.getPassword().length() < 6) {
            errors.rejectValue("password", "TooShort", new Object[]{6}, null);
        }
        if (StringUtils.isNotEmpty((String)form.getPasswordConfirmation()) && !StringUtils.equals((String)form.getPassword(), (String)form.getPasswordConfirmation())) {
            errors.rejectValue("passwordConfirmation", "Unmatching");
        }
    }
}

