/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.firstconnection.portlet.service;

import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import org.apache.commons.lang.StringUtils;
import org.osivia.portal.api.PortalException;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.directory.v2.model.Person;
import org.osivia.portal.api.directory.v2.service.PersonService;
import org.osivia.portal.api.urls.IPortalUrlFactory;
import org.osivia.services.firstconnection.portlet.model.UserForm;
import org.osivia.services.firstconnection.portlet.repository.FirstConnectionRepository;
import org.osivia.services.firstconnection.portlet.service.FirstConnectionService;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Service;

@Service
public class FirstConnectionServiceImpl
implements FirstConnectionService,
ApplicationContextAware {
    @Autowired
    private FirstConnectionRepository repository;
    @Autowired
    private PersonService personService;
    @Autowired
    private IPortalUrlFactory portalUrlFactory;
    private ApplicationContext applicationContext;

    public UserForm getUserForm(PortalControllerContext portalControllerContext) throws PortletException {
        PortletRequest request = portalControllerContext.getRequest();
        String user = request.getRemoteUser();
        UserForm form = (UserForm)this.applicationContext.getBean(UserForm.class);
        form.setId(user);
        form.setEmail(user);
        return form;
    }

    public void save(PortalControllerContext portalControllerContext, UserForm form) throws PortletException {
        Person person = this.personService.getPerson(form.getId());
        String title = form.getTitle();
        person.setTitle(StringUtils.trimToNull((String)title));
        String firstName = form.getFirstName();
        person.setGivenName(firstName);
        String lastName = form.getLastName();
        person.setSn(lastName);
        String displayName = firstName + " " + lastName;
        person.setCn(displayName);
        person.setDisplayName(displayName);
        this.personService.update(person);
        String password = form.getPassword();
        this.personService.updatePassword(person, password);
    }

    public String getRedirectionUrl(PortalControllerContext portalControllerContext) throws PortletException {
        String redirectionUrl = this.repository.getRedirectionUrl(portalControllerContext);
        if (redirectionUrl != null) {
            try {
                redirectionUrl = this.portalUrlFactory.getDestroyCurrentPageUrl(portalControllerContext, redirectionUrl);
            }
            catch (PortalException e) {
                throw new PortletException((Throwable)e);
            }
        }
        return redirectionUrl;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

