/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.portal.services.inscription;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.osivia.portal.services.inscription.InfosForm;
import org.springframework.stereotype.Component;
import org.springframework.validation.Errors;
import org.springframework.validation.ValidationUtils;
import org.springframework.validation.Validator;

@Component
public class InfosFormValidator
implements Validator {
    private static String ATOM = "[a-z0-9!#$%&'*+/=?^_`{|}~-]";
    private static String DOMAIN = "(" + ATOM + "+(\\." + ATOM + "+)*";
    private static String IP_DOMAIN = "\\[[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\]";
    private Pattern pattern = Pattern.compile("^" + ATOM + "+(\\." + ATOM + "+)*@" + DOMAIN + "|" + IP_DOMAIN + ")$", 2);

    public boolean supports(Class<?> clazz) {
        return InfosForm.class.isAssignableFrom(clazz);
    }

    public void validate(Object target, Errors errors) {
        InfosForm infosForm = (InfosForm)target;
        ValidationUtils.rejectIfEmpty((Errors)errors, (String)"nom", (String)"empty");
        ValidationUtils.rejectIfEmpty((Errors)errors, (String)"prenom", (String)"empty");
        ValidationUtils.rejectIfEmpty((Errors)errors, (String)"mail", (String)"empty");
        ValidationUtils.rejectIfEmpty((Errors)errors, (String)"societe", (String)"empty");
        Matcher m = this.pattern.matcher(infosForm.getMail());
        if (!m.matches()) {
            errors.rejectValue("mail", "badaddress");
        }
    }
}

