/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.calendar.portlet.controller;

import fr.toutatice.portail.cms.nuxeo.api.CMSPortlet;
import javax.annotation.PostConstruct;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.commons.lang.StringUtils;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.services.calendar.portlet.model.calendar.CalendarData;
import org.osivia.services.calendar.portlet.service.ICalendarService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.portlet.bind.annotation.ActionMapping;
import org.springframework.web.portlet.bind.annotation.RenderMapping;
import org.springframework.web.portlet.context.PortletConfigAware;
import org.springframework.web.portlet.context.PortletContextAware;

@Controller
@RequestMapping(value={"VIEW"})
public class ViewCalendarController
extends CMSPortlet
implements PortletContextAware,
PortletConfigAware {
    private static final String ERROR_PATH = "calendar/error";
    private static final String CALENDAR_DATA_ATTRIBUTE = "calendarData";
    private static final String EVENTS_DATA_ATTRIBUTE = "eventsData";
    private static final String SELECTED_DATE_ATTRIBUTE = "date";
    private static final String ERROR_MESSAGE_ATTRIBUTE = "message";
    @Autowired
    private ICalendarService calendarService;
    private PortletContext portletContext;
    private PortletConfig portletConfig;

    @PostConstruct
    public void postConstruct() throws PortletException {
        super.init(this.portletConfig);
    }

    @RenderMapping
    public String view(RenderRequest request, RenderResponse response, @RequestParam(value="date", required=false) String selectedDate, @ModelAttribute CalendarData calendarData) throws PortletException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        request.setAttribute(SELECTED_DATE_ATTRIBUTE, (Object)selectedDate);
        request.setAttribute(EVENTS_DATA_ATTRIBUTE, (Object)this.calendarService.getEventsData(portalControllerContext, calendarData));
        String title = this.calendarService.getTitle(portalControllerContext);
        if (StringUtils.isNotBlank((String)title)) {
            response.setTitle(title);
        }
        return this.calendarService.getViewPath(portalControllerContext, calendarData);
    }

    @ExceptionHandler(value={Exception.class})
    public String handleException(PortletRequest request, PortletResponse response, Exception exception) {
        request.setAttribute(ERROR_MESSAGE_ATTRIBUTE, (Object)exception.getMessage());
        return ERROR_PATH;
    }

    @ActionMapping(value="today")
    public void selectToday(ActionRequest request, ActionResponse response) throws PortletException {
        response.setRenderParameter(SELECTED_DATE_ATTRIBUTE, "");
    }

    @ActionMapping(value="previous")
    public void selectPreviousPeriod(ActionRequest request, ActionResponse response, @ModelAttribute(value="calendarData") CalendarData calendarData) throws PortletException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        String selectedDate = this.calendarService.selectPreviousPeriod(portalControllerContext, calendarData);
        response.setRenderParameter(SELECTED_DATE_ATTRIBUTE, selectedDate);
    }

    @ActionMapping(value="next")
    public void selectNextPeriod(ActionRequest request, ActionResponse response, @ModelAttribute(value="calendarData") CalendarData calendarData) throws PortletException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        String selectedDate = this.calendarService.selectNextPeriod(portalControllerContext, calendarData);
        response.setRenderParameter(SELECTED_DATE_ATTRIBUTE, selectedDate);
    }

    @ModelAttribute(value="calendarData")
    public CalendarData getCalendarData(PortletRequest request, PortletResponse response, @RequestParam(value="period", required=false) String periodTypeName) throws PortletException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, request, response);
        return this.calendarService.getCalendarData(portalControllerContext, periodTypeName);
    }

    public void setPortletContext(PortletContext portletContext) {
        this.portletContext = portletContext;
    }

    public void setPortletConfig(PortletConfig portletConfig) {
        this.portletConfig = portletConfig;
    }
}

