/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.calendar.portlet.service;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.Map;
import javax.portlet.PortletException;
import javax.portlet.WindowState;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.internationalization.Bundle;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.portal.api.internationalization.IInternationalizationService;
import org.osivia.portal.api.locator.Locator;
import org.osivia.services.calendar.portlet.model.CalendarConfiguration;
import org.osivia.services.calendar.portlet.model.calendar.CalendarData;
import org.osivia.services.calendar.portlet.model.events.EventsData;
import org.osivia.services.calendar.portlet.repository.ICalendarRepository;
import org.osivia.services.calendar.portlet.service.ICalendarService;
import org.osivia.services.calendar.portlet.service.generator.ICalendarGenerator;
import org.osivia.services.calendar.portlet.utils.PeriodTypes;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Service;

@Service
public class CalendarServiceImpl
implements ICalendarService,
ApplicationContextAware {
    @Autowired
    private ICalendarRepository calendarRepository;
    private ApplicationContext applicationContext;
    private final IBundleFactory bundleFactory;

    public CalendarServiceImpl() {
        IInternationalizationService internationalizationService = (IInternationalizationService)Locator.findMBean(IInternationalizationService.class, (String)"osivia:service=InternationalizationService");
        this.bundleFactory = internationalizationService.getBundleFactory(this.getClass().getClassLoader());
    }

    public String getTitle(PortalControllerContext portalControllerContext) throws PortletException {
        return this.calendarRepository.getTitle(portalControllerContext);
    }

    public CalendarData getCalendarData(PortalControllerContext portalControllerContext, String periodTypeName) throws PortletException {
        PeriodTypes periodType = this.getPeriodType(portalControllerContext, periodTypeName);
        ICalendarGenerator generator = this.getGenerator(portalControllerContext, periodType);
        return generator.generateCalendarData(portalControllerContext);
    }

    private PeriodTypes getPeriodType(PortalControllerContext portalControllerContext, String periodTypeName) throws PortletException {
        CalendarConfiguration configuration = this.calendarRepository.getConfiguration(portalControllerContext);
        if (StringUtils.isBlank((String)configuration.getCmsPath())) {
            throw new PortletException(this.getInternationalizedProperty(portalControllerContext, "MESSAGE_CMS_PATH_NOT_DEFINED"));
        }
        PeriodTypes periodType = periodTypeName == null ? PeriodTypes.fromName((String)configuration.getPeriodTypeName()) : PeriodTypes.fromName((String)periodTypeName);
        if (this.isCompact(portalControllerContext) && !periodType.isCompactable()) {
            periodType = PeriodTypes.PLANNING;
        }
        return periodType;
    }

    private ICalendarGenerator getGenerator(PortalControllerContext portalControllerContext, PeriodTypes periodType) throws PortletException {
        ICalendarGenerator result = null;
        Map generators = this.applicationContext.getBeansOfType(ICalendarGenerator.class);
        for (ICalendarGenerator generator : generators.values()) {
            if (!generator.getPeriodType().equals((Object)periodType)) continue;
            result = generator;
            break;
        }
        return result;
    }

    public boolean isCompact(PortalControllerContext portalControllerContext) throws PortletException {
        CalendarConfiguration configuration = this.calendarRepository.getConfiguration(portalControllerContext);
        boolean maximized = WindowState.MAXIMIZED.equals((Object)portalControllerContext.getRequest().getWindowState());
        return configuration.isCompactView() && !maximized;
    }

    public EventsData getEventsData(PortalControllerContext portalControllerContext, CalendarData calendarData) throws PortletException {
        ICalendarGenerator generator = calendarData.getGenerator();
        return generator.generateEventsData(portalControllerContext, calendarData);
    }

    public String getViewPath(PortalControllerContext portalControllerContext, CalendarData calendarData) throws PortletException {
        PeriodTypes periodType = calendarData.getPeriodType();
        this.calendarRepository.insertContentMenubarItems(portalControllerContext);
        String viewPath = periodType.getViewPath();
        if (this.isCompact(portalControllerContext) && periodType.isCompactable()) {
            viewPath = viewPath + "-compact";
        }
        return viewPath;
    }

    public String selectPreviousPeriod(PortalControllerContext portalControllerContext, CalendarData calendarData) throws PortletException {
        return this.changeSelectedDate(portalControllerContext, calendarData, -1);
    }

    public String selectNextPeriod(PortalControllerContext portalControllerContext, CalendarData calendarData) throws PortletException {
        return this.changeSelectedDate(portalControllerContext, calendarData, 1);
    }

    private String changeSelectedDate(PortalControllerContext portalControllerContext, CalendarData calendarData, int diff) throws PortletException {
        Date selectedDate = calendarData.getSelectedDate();
        Calendar calendar = GregorianCalendar.getInstance(portalControllerContext.getRequest().getLocale());
        calendar.setTime(selectedDate);
        calendar.add(calendarData.getPeriodType().getField(), diff);
        selectedDate = calendar.getTime();
        ICalendarGenerator generator = calendarData.getGenerator();
        generator.updateCalendarData(portalControllerContext, calendarData, selectedDate);
        generator.generateEventsData(portalControllerContext, calendarData);
        return StringEscapeUtils.escapeHtml((String)SELECTED_DATE_FORMAT.format(selectedDate));
    }

    private String getInternationalizedProperty(PortalControllerContext portalControllerContext, String key) {
        Locale locale = portalControllerContext.getRequest().getLocale();
        Bundle bundle = this.bundleFactory.getBundle(locale);
        return bundle.getString(key);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

