<%@ taglib uri="http://java.sun.com/portlet_2_0" prefix="portlet"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@ taglib uri="http://www.springframework.org/tags/form" prefix="form"%>
<%@ taglib uri="internationalization" prefix="is"%>

<%@ page contentType="text/html" isELIgnored="false"%>


<portlet:defineObjects />

<portlet:actionURL name="save" var="saveActionURL" />


<form:form modelAttribute="configuration" action="${saveActionURL}" method="post" cssClass="form-horizontal" role="form">
    <!-- CMS path -->
    <div class="form-group">
        <form:label path="cmsPath" cssClass="control-label col-sm-3"><is:getProperty key="CALENDAR_CMS_PATH" /></form:label>
        <div class="col-sm-9">
            <form:input path="cmsPath" cssClass="form-control" />
        </div>
    </div>
    
    <!-- Document version -->
    <div class="form-group">
        <form:label path="version" cssClass="control-label col-sm-3"><is:getProperty key="CALENDAR_VERSION" /></form:label>
        <div class="col-sm-9">
            <form:select path="version" cssClass="form-control">
                <form:option value=""><is:getProperty key="CALENDAR_VERSION_DEFAULT" /></form:option>
                <form:option value="live"><is:getProperty key="CALENDAR_VERSION_LIVE" /></form:option>
                <form:option value="proxy"><is:getProperty key="CALENDAR_VERSION_PROXY" /></form:option>
            </form:select>
        </div>
    </div>
    
    <!-- Default view -->
    <div class="form-group">
        <form:label path="periodTypeName" cssClass="control-label col-sm-3"><is:getProperty key="CALENDAR_DEFAULT_VIEW" /></form:label>
        <div class="col-sm-9">
            <form:select path="periodTypeName" cssClass="form-control">
                <form:option value=""></form:option>
                <c:forEach var="periodType" items="${periodTypes}">
                    <form:option value="${periodType.key}">${periodType.value}</form:option>
                </c:forEach>
            </form:select>
        </div>
    </div>
    
    <!-- Compact view -->
    <div class="form-group">
        <form:label path="compactView" cssClass="control-label col-sm-3"><is:getProperty key="CALENDAR_PLANNING" /></form:label>
        <div class="col-sm-9">
            <div class="checkbox">
                <label>
                    <form:checkbox path="compactView" />
                    <span><is:getProperty key="CALENDAR_COMPACT_VIEW" /></span>
                </label>
            </div>
            <span class="help-block"><is:getProperty key="CALENDAR_COMPACT_VIEW_HELP" /></span>
        </div>
    </div>
    
    <!-- Buttons -->
    <div class="form-group">
        <div class="col-sm-offset-4 col-sm-8">
            <button type="submit" class="btn btn-primary">
                <i class="glyphicons glyphicons-floppy-disk"></i>
                <span><is:getProperty key="SAVE" /></span>
            </button>
            <button type="button" class="btn btn-default" onclick="closeFancybox()"><is:getProperty key="CANCEL" /></button>
        </div>
    </div>
</form:form>
