/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.calendar.portlet.service.generator;

import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import javax.portlet.PortletException;
import org.apache.commons.lang.time.DateUtils;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.portal.api.internationalization.IInternationalizationService;
import org.osivia.portal.api.locator.Locator;
import org.osivia.services.calendar.portlet.model.calendar.CalendarData;
import org.osivia.services.calendar.portlet.model.events.Event;
import org.osivia.services.calendar.portlet.model.events.EventsData;
import org.osivia.services.calendar.portlet.repository.ICalendarRepository;
import org.osivia.services.calendar.portlet.service.ICalendarService;
import org.osivia.services.calendar.portlet.service.generator.ICalendarGenerator;
import org.osivia.services.calendar.portlet.utils.PeriodTypes;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class CalendarGeneratorImpl
implements ICalendarGenerator {
    protected static final int HOUR_DISPLAY_HEIGHT = 40;
    protected static final int DEFAULT_SCROLL_TOP_HOUR = 7;
    private static final int PLANNING_DAY_LIMIT = 20;
    private static final float ROUND_FACTOR = 1000.0f;
    @Autowired
    private ICalendarRepository calendarRepository;
    private final IBundleFactory bundleFactory;

    public CalendarGeneratorImpl() {
        IInternationalizationService internationalizationService = (IInternationalizationService)Locator.findMBean(IInternationalizationService.class, (String)"osivia:service=InternationalizationService");
        this.bundleFactory = internationalizationService.getBundleFactory(this.getClass().getClassLoader());
    }

    public CalendarData generateCalendarData(PortalControllerContext portalControllerContext) throws PortletException {
        CalendarData calendarData = this.generateSpecializedCalendarData(portalControllerContext);
        calendarData.setPeriodType(this.getPeriodType());
        calendarData.setGenerator((ICalendarGenerator)this);
        this.fillCalendarDates(portalControllerContext, calendarData, null);
        return calendarData;
    }

    protected abstract CalendarData generateSpecializedCalendarData(PortalControllerContext var1) throws PortletException;

    public void updateCalendarData(PortalControllerContext portalControllerContext, CalendarData calendarData, Date selectedDate) throws PortletException {
        this.fillCalendarDates(portalControllerContext, calendarData, selectedDate);
        this.updateSpecializedCalendarData(portalControllerContext, calendarData);
    }

    protected abstract void updateSpecializedCalendarData(PortalControllerContext var1, CalendarData var2);

    private void fillCalendarDates(PortalControllerContext portalControllerContext, CalendarData calendarData, Date forcedSelectedDate) throws PortletException {
        PeriodTypes periodType = calendarData.getPeriodType();
        Date selectedDate = forcedSelectedDate;
        if (selectedDate == null) {
            selectedDate = this.getSelectedDate(portalControllerContext);
        }
        calendarData.setSelectedDate(selectedDate);
        Date startDate = this.getStartDate(portalControllerContext, periodType, selectedDate);
        calendarData.setStartDate(startDate);
        Date endDate = this.getEndDate(portalControllerContext, periodType, selectedDate, startDate);
        calendarData.setEndDate(endDate);
        String displayDate = this.getDisplayDate(portalControllerContext, calendarData);
        calendarData.setDisplayDate(displayDate);
    }

    protected Date getSelectedDate(PortalControllerContext portalControllerContext) {
        Date selectedDate = null;
        String parameter = portalControllerContext.getRequest().getParameter("date");
        if (parameter != null) {
            try {
                selectedDate = ICalendarService.SELECTED_DATE_FORMAT.parse(parameter);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        if (selectedDate == null) {
            selectedDate = new Date();
        }
        return DateUtils.truncate((Date)selectedDate, (int)5);
    }

    protected Date getStartDate(PortalControllerContext portalControllerContext, PeriodTypes periodType, Date selectedDate) {
        Calendar calendar = GregorianCalendar.getInstance(portalControllerContext.getRequest().getLocale());
        calendar.setTime(selectedDate);
        if (PeriodTypes.MONTH.equals((Object)periodType)) {
            calendar.set(5, calendar.getActualMinimum(5));
            calendar.getTimeInMillis();
            calendar.set(7, calendar.getFirstDayOfWeek());
        } else if (PeriodTypes.WEEK.equals((Object)periodType)) {
            calendar.set(7, calendar.getFirstDayOfWeek());
        }
        return calendar.getTime();
    }

    protected Date getEndDate(PortalControllerContext portalControllerContext, PeriodTypes periodType, Date selectedDate, Date startDate) {
        Calendar calendar = GregorianCalendar.getInstance(portalControllerContext.getRequest().getLocale());
        if (PeriodTypes.MONTH.equals((Object)periodType)) {
            calendar.setTime(selectedDate);
            calendar.set(5, calendar.getActualMaximum(5));
            calendar.getTimeInMillis();
            calendar.set(7, calendar.getFirstDayOfWeek());
            calendar.add(3, 1);
        } else {
            calendar.setTime(startDate);
            if (PeriodTypes.PLANNING.equals((Object)periodType)) {
                calendar.add(periodType.getField(), 20);
            } else {
                calendar.add(periodType.getField(), 1);
            }
        }
        calendar.add(14, -1);
        return calendar.getTime();
    }

    protected abstract String getDisplayDate(PortalControllerContext var1, CalendarData var2) throws PortletException;

    public EventsData generateEventsData(PortalControllerContext portalControllerContext, CalendarData calendarData) throws PortletException {
        List events = this.calendarRepository.getEvents(portalControllerContext, calendarData);
        EventsData eventsData = events == null ? null : this.generateSpecializedEventsData(portalControllerContext, calendarData, events);
        return eventsData;
    }

    protected abstract EventsData generateSpecializedEventsData(PortalControllerContext var1, CalendarData var2, List<Event> var3) throws PortletException;

    protected float getEventHours(Calendar startCalendar, Calendar endCalendar, boolean begin, boolean end) {
        long start = begin ? DateUtils.getFragmentInMilliseconds((Calendar)startCalendar, (int)5) : 0L;
        long stop = end ? DateUtils.getFragmentInMilliseconds((Calendar)endCalendar, (int)5) : 86400000L;
        float hours = Long.valueOf(stop - start).floatValue() / Float.valueOf(3600000.0f).floatValue();
        return (float)Math.round(hours * 1000.0f) / 1000.0f;
    }

    public IBundleFactory getBundleFactory() {
        return this.bundleFactory;
    }
}

