/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.calendar.plugin;

import fr.toutatice.portail.cms.nuxeo.api.domain.AbstractPluginPortlet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletContext;
import org.osivia.portal.api.cms.DocumentType;
import org.osivia.portal.api.customization.CustomizationContext;
import org.osivia.portal.api.customization.Plugin;
import org.osivia.portal.api.taskbar.TaskbarFactory;
import org.osivia.portal.api.taskbar.TaskbarItem;
import org.osivia.portal.api.taskbar.TaskbarItems;
import org.osivia.services.calendar.plugin.CalendarPlayer;

@Plugin(value="calendar.plugin")
public class CalendarPlugin
extends AbstractPluginPortlet {
    private static final String PLUGIN_NAME = "calendar.plugin";

    protected void customizeCMSProperties(String customizationID, CustomizationContext context) {
        this.customizeDocumentTypes(context);
        this.customizePlayers(context);
        this.customizeTaskbarItems(context);
    }

    private void customizeDocumentTypes(CustomizationContext context) {
        Map types = this.getDocTypes(context);
        DocumentType event = new DocumentType("VEVENT", false, false, false, false, true, true, new ArrayList(0), null, "glyphicons glyphicons-important-day", false, false);
        types.put(event.getName(), event);
        DocumentType calendar = new DocumentType("Agenda", true, true, false, false, true, true, Arrays.asList(event.getName()), null, "glyphicons glyphicons-calendar");
        types.put(calendar.getName(), calendar);
    }

    private void customizePlayers(CustomizationContext context) {
        PortletContext portletContext = this.getPortletContext();
        List players = this.getPlayers(context);
        CalendarPlayer calendar = new CalendarPlayer(portletContext);
        players.add(calendar);
    }

    private void customizeTaskbarItems(CustomizationContext context) {
        TaskbarItems items = this.getTaskbarItems(context);
        TaskbarFactory factory = this.getTaskbarService().getFactory();
        TaskbarItem agenda = factory.createCmsTaskbarItem("CALENDAR", "CALENDAR_TASK", "glyphicons glyphicons-calendar", "Agenda");
        agenda.setToDefault(3);
        items.add(agenda);
    }

    protected String getPluginName() {
        return PLUGIN_NAME;
    }
}

