/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.calendar.view.portlet.service.generator;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import javax.portlet.PortletException;
import org.apache.commons.lang.time.DateUtils;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.services.calendar.view.portlet.model.calendar.CalendarData;
import org.osivia.services.calendar.view.portlet.model.events.DailyCalendarEventsData;
import org.osivia.services.calendar.view.portlet.model.events.Event;
import org.osivia.services.calendar.view.portlet.model.events.EventsData;
import org.osivia.services.calendar.view.portlet.model.events.TimeSlotEvent;
import org.osivia.services.calendar.view.portlet.service.generator.CalendarGeneratorImpl;
import org.osivia.services.calendar.view.portlet.utils.PeriodTypes;
import org.springframework.stereotype.Service;

@Service(value="schedulerCalendarGenerator")
public class SchedulerCalendarGeneratorImpl
extends CalendarGeneratorImpl {
    public SchedulerCalendarGeneratorImpl() {
        this.periodType = PeriodTypes.WEEK;
    }

    @Override
    protected EventsData generateSpecializedEventsData(PortalControllerContext portalControllerContext, CalendarData calendarData, List<Event> events) throws PortletException {
        Locale locale = portalControllerContext.getRequest().getLocale();
        Calendar startCalendar = GregorianCalendar.getInstance(locale);
        ArrayList<TimeSlotEvent> dailyEvents = new ArrayList<TimeSlotEvent>(events.size());
        for (Event event : events) {
            Date currentDate = DateUtils.truncate((Date)startCalendar.getTime(), (int)5);
            TimeSlotEvent timeSlotEvent = new TimeSlotEvent(event, currentDate);
            dailyEvents.add(timeSlotEvent);
        }
        DailyCalendarEventsData eventsData = new DailyCalendarEventsData();
        eventsData.setEvents(dailyEvents);
        return eventsData;
    }
}

