/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.calendar.common.repository;

import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.cms.NuxeoDocumentContext;
import fr.toutatice.portail.cms.nuxeo.api.cms.NuxeoPublicationInfos;
import java.util.List;
import javax.portlet.MimeResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.portlet.WindowState;
import org.nuxeo.ecm.automation.client.model.Document;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.internationalization.Bundle;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.portal.api.menubar.MenubarContainer;
import org.osivia.portal.api.menubar.MenubarGroup;
import org.osivia.portal.api.menubar.MenubarItem;
import org.osivia.services.calendar.common.repository.CalendarRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository(value="common-repository")
public class CalendarRepositoryImpl
implements CalendarRepository {
    @Autowired
    private IBundleFactory bundleFactory;

    @Override
    public Document getCurrentDocument(PortalControllerContext portalControllerContext) throws PortletException {
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        NuxeoDocumentContext documentContext = nuxeoController.getCurrentDocumentContext();
        Document document = documentContext == null ? null : documentContext.getDocument();
        return document;
    }

    @Override
    public String getTitle(PortalControllerContext portalControllerContext, Document document) {
        String title = document == null ? null : document.getTitle();
        return title;
    }

    @Override
    public void insertContentMenubarItems(PortalControllerContext portalControllerContext) throws PortletException {
        PortletRequest request = portalControllerContext.getRequest();
        PortletResponse response = portalControllerContext.getResponse();
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        NuxeoDocumentContext documentContext = nuxeoController.getCurrentDocumentContext();
        if (documentContext != null) {
            Document document = documentContext.getDocument();
            nuxeoController.setCurrentDoc(document);
            Bundle bundle = this.bundleFactory.getBundle(request.getLocale());
            if (WindowState.MAXIMIZED.equals((Object)request.getWindowState())) {
                nuxeoController.insertContentMenuBarItems();
                if (document != null && "Agenda".equals(document.getType()) && response instanceof MimeResponse) {
                    MimeResponse mimeResponse = (MimeResponse)response;
                    PortletURL actionUrl = mimeResponse.createActionURL();
                    actionUrl.setParameters(request.getParameterMap());
                    actionUrl.setParameter("javax.portlet.action", "synchronize");
                    List menubar = (List)request.getAttribute("osivia.menuBar");
                    MenubarItem menubarItem = new MenubarItem("SYNCHRONIZED_CALENDAR", bundle.getString("REFRESH"), "glyphicons glyphicons-repeat", (MenubarContainer)MenubarGroup.GENERIC, 100, actionUrl.toString(), null, null, null);
                    menubar.add(menubarItem);
                }
            }
        }
    }

    @Override
    public boolean isWorkspace(PortalControllerContext portalControllerContext, Document document) {
        boolean workspace;
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        if (document == null) {
            workspace = false;
        } else {
            NuxeoDocumentContext documentContext = nuxeoController.getDocumentContext(document.getPath());
            NuxeoPublicationInfos publicationInfos = documentContext.getPublicationInfos();
            workspace = publicationInfos.isLiveSpace();
        }
        return workspace;
    }
}

