/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.calendar.integration.portlet.service;

import java.util.HashMap;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import org.apache.commons.lang.StringUtils;
import org.osivia.portal.api.PortalException;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.urls.IPortalUrlFactory;
import org.osivia.portal.api.windows.PortalWindow;
import org.osivia.portal.api.windows.WindowFactory;
import org.osivia.services.calendar.integration.portlet.model.CalendarIntegrationForm;
import org.osivia.services.calendar.integration.portlet.service.CalendarIntegrationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service
public class CalendarIntegrationServiceImpl
implements CalendarIntegrationService {
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private IPortalUrlFactory portalUrlFactory;

    @Override
    public CalendarIntegrationForm getForm(PortalControllerContext portalControllerContext) throws PortletException {
        String url;
        String path = this.getCalendarPath(portalControllerContext);
        CalendarIntegrationForm form = (CalendarIntegrationForm)this.applicationContext.getBean(CalendarIntegrationForm.class);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("format", "ics");
        try {
            url = this.portalUrlFactory.getPermaLink(portalControllerContext, "integration", parameters, path, "resource");
        }
        catch (PortalException e) {
            throw new PortletException((Throwable)e);
        }
        url = StringUtils.replace((String)url, (String)"/commands?", (String)"/commands/events.ics?");
        form.setUrl(url);
        return form;
    }

    protected String getCalendarPath(PortalControllerContext portalControllerContext) {
        PortletRequest request = portalControllerContext.getRequest();
        PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
        return window.getProperty("osivia.cms.uri");
    }
}

