/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.calendar.event.view.portlet.service;

import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.cms.NuxeoDocumentContext;
import fr.toutatice.portail.cms.nuxeo.api.services.dao.DocumentDAO;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import javax.activation.MimeType;
import javax.activation.MimeTypeParseException;
import javax.portlet.PortletException;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.PropertyList;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.services.calendar.common.model.Attachment;
import org.osivia.services.calendar.common.model.Attachments;
import org.osivia.services.calendar.common.model.CalendarColor;
import org.osivia.services.calendar.common.repository.CalendarRepository;
import org.osivia.services.calendar.common.service.CalendarServiceImpl;
import org.osivia.services.calendar.event.view.portlet.model.CalendarEventViewForm;
import org.osivia.services.calendar.event.view.portlet.service.CalendarEventViewService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service
public class CalendarEventViewServiceImpl
extends CalendarServiceImpl
implements CalendarEventViewService {
    protected final DateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy");
    @Autowired
    protected ApplicationContext applicationContext;
    @Autowired
    @Qualifier(value="common-repository")
    protected CalendarRepository repository;
    @Autowired
    protected DocumentDAO dao;

    public CalendarEventViewServiceImpl() {
        this.dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    @Override
    public void insertContentMenubarItems(PortalControllerContext portalControllerContext) throws PortletException {
        this.repository.insertContentMenubarItems(portalControllerContext);
    }

    @Override
    public CalendarEventViewForm getForm(PortalControllerContext portalControllerContext) throws PortletException {
        CalendarEventViewForm form = (CalendarEventViewForm)this.applicationContext.getBean(CalendarEventViewForm.class);
        Document document = this.repository.getCurrentDocument(portalControllerContext);
        form.setDocument(this.dao.toDTO(document));
        form.setTitle(document.getString("dc:title"));
        boolean allDay = this.isAllDay(portalControllerContext, document);
        form.setAllDay(allDay);
        form.setStartDate(document.getDate("vevent:dtstart"));
        form.setEndDate(document.getDate("vevent:dtend"));
        form.setSameDay(this.isSameDay(form));
        form.setEndDateAllDay(this.getEndDateAllDay(form));
        String location = this.getLocation(portalControllerContext, document);
        form.setLocation(location);
        CalendarColor calendarColor = this.getCalendarColor(portalControllerContext, document);
        CalendarColor color = this.getColor(portalControllerContext, document, calendarColor);
        form.setColor(color);
        String description = this.getDescription(portalControllerContext, document);
        form.setDescription(description);
        this.setAttachments(portalControllerContext, document, form);
        boolean workspace = this.repository.isWorkspace(portalControllerContext, document);
        form.setWorkspace(workspace);
        return form;
    }

    @Override
    public CalendarColor getCalendarColor(PortalControllerContext portalControllerContext, Document document) throws PortletException {
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        String eventPath = document.getPath();
        String path = StringUtils.substringBeforeLast((String)eventPath, (String)"/");
        NuxeoDocumentContext documentContext = nuxeoController.getDocumentContext(path);
        Document calendar = documentContext.getDocument();
        String colorId = null;
        if (calendar != null) {
            String sourceId = document.getString("sync:idParentSource");
            if (sourceId == null || sourceId.isEmpty()) {
                colorId = calendar.getString("cal:color");
            } else {
                PropertyList propertyList = (PropertyList)calendar.getProperties().get("cal:sources");
                if (propertyList != null) {
                    for (int i = 0; i < propertyList.size(); ++i) {
                        PropertyMap map = propertyList.getMap(i);
                        if (!sourceId.equals(map.get("sourceId"))) continue;
                        colorId = map.getString("color");
                        break;
                    }
                }
            }
        }
        return CalendarColor.fromId(colorId);
    }

    protected void setAttachments(PortalControllerContext portalControllerContext, Document document, CalendarEventViewForm form) {
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        Attachments attachments = (Attachments)this.applicationContext.getBean(Attachments.class);
        form.setAttachments(attachments);
        PropertyList attachmentsList = document.getProperties().getList("files:files");
        if (attachmentsList != null) {
            ArrayList<Attachment> files = new ArrayList<Attachment>(attachmentsList.size());
            for (int i = 0; i < attachmentsList.size(); ++i) {
                MimeType mimeType;
                PropertyMap map = attachmentsList.getMap(i);
                PropertyMap fileMap = map.getMap("file");
                Attachment file = (Attachment)this.applicationContext.getBean(Attachment.class);
                String fileName = fileMap.getString("name");
                file.setTemporaryFileName(fileName);
                try {
                    mimeType = new MimeType(fileMap.getString("mime-type"));
                }
                catch (MimeTypeParseException e) {
                    mimeType = null;
                }
                file.setIcon(this.dao.getIcon(mimeType));
                String url = nuxeoController.createAttachedFileLink(document.getPath(), String.valueOf(i));
                file.setUrl(url);
                files.add(file);
            }
            attachments.setFiles(files);
        }
    }

    protected Date getEndDateAllDay(CalendarEventViewForm form) {
        if (form.getEndDate() != null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(form.getEndDate());
            cal.add(5, -1);
            return cal.getTime();
        }
        return null;
    }

    protected boolean isSameDay(CalendarEventViewForm form) {
        boolean sameDay = false;
        Calendar calStart = Calendar.getInstance();
        Calendar calEnd = Calendar.getInstance();
        calStart.setTime(form.getStartDate());
        calEnd.setTime(form.getEndDate());
        if (form.isAllDay()) {
            long diff = 0L;
            diff = Math.round((calEnd.getTime().getTime() - calStart.getTime().getTime()) / 86400000L);
            sameDay = diff <= 1L;
        } else {
            calStart.set(11, 0);
            calStart.set(12, 0);
            calStart.set(13, 0);
            calStart.set(14, 0);
            calEnd.set(11, 0);
            calEnd.set(12, 0);
            calEnd.set(13, 0);
            calEnd.set(14, 0);
            sameDay = this.dateFormat.format(calStart.getTime()).equals(this.dateFormat.format(calEnd.getTime()));
        }
        return sameDay;
    }

    protected boolean isAllDay(PortalControllerContext portalControllerContext, Document document) throws PortletException {
        boolean allDay = document == null ? false : BooleanUtils.toBoolean((Boolean)document.getProperties().getBoolean("vevent:allDay"));
        return allDay;
    }

    protected String getLocation(PortalControllerContext portalControllerContext, Document document) throws PortletException {
        String location = document == null ? null : document.getString("vevent:location");
        return location;
    }

    private CalendarColor getColor(PortalControllerContext portalControllerContext, Document document, CalendarColor calendarColor) throws PortletException {
        String colorId = document == null ? null : document.getString("vevent:color");
        if (colorId == null && calendarColor != null) {
            colorId = calendarColor.getId();
        }
        return CalendarColor.fromId(colorId);
    }

    protected String getDescription(PortalControllerContext portalControllerContext, Document document) throws PortletException {
        String description = document == null ? null : document.getString("note:note");
        return description;
    }
}

