/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.contact.portlet.controller;

import com.github.cage.GCage;
import com.sun.mail.smtp.SMTPTransport;
import fr.toutatice.portail.cms.nuxeo.api.CMSPortlet;
import java.io.IOException;
import java.util.Date;
import java.util.Properties;
import javax.annotation.PostConstruct;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import org.apache.commons.lang.StringUtils;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.internationalization.Bundle;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.portal.api.notifications.INotificationsService;
import org.osivia.portal.api.windows.PortalWindow;
import org.osivia.portal.api.windows.WindowFactory;
import org.osivia.services.contact.portlet.model.Form;
import org.osivia.services.contact.portlet.model.FormCaptcha;
import org.osivia.services.contact.portlet.model.validation.ContactFormValidator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Validator;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.support.SessionStatus;
import org.springframework.web.portlet.bind.annotation.ActionMapping;
import org.springframework.web.portlet.bind.annotation.RenderMapping;
import org.springframework.web.portlet.bind.annotation.ResourceMapping;
import org.springframework.web.portlet.context.PortletConfigAware;
import org.springframework.web.portlet.context.PortletContextAware;

/*
 * Exception performing whole class analysis ignored.
 */
@Controller
@RequestMapping(value={"VIEW"})
public class ContactController
extends CMSPortlet
implements PortletConfigAware,
PortletContextAware {
    private static final String DEFAULT_VIEW = "view";
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private IBundleFactory bundleFactory;
    @Autowired
    private INotificationsService notificationService;
    @Autowired
    private ContactFormValidator formValidator;
    private PortletConfig portletConfig;
    private PortletContext portletContext;

    private static String bodyFormat(Form form, Bundle bundle) {
        StringBuilder sb = new StringBuilder();
        sb.append(bundle.getString("NEW_MAIL") + form.getNom() + " (" + form.getFrom() + ")");
        sb.append("<br />");
        sb.append(bundle.getString("NEW_MAIL_SUBJECT") + form.getObject());
        sb.append("<br />");
        String body = form.getBody();
        body = body.replaceAll("(\r\n|\n)", "<br />");
        sb.append(body);
        return sb.toString();
    }

    @PostConstruct
    public void postConstruct() throws PortletException {
        super.init(this.portletConfig);
    }

    @RenderMapping
    public String defaultView(RenderRequest request, RenderResponse response) throws PortletException {
        return "view";
    }

    @ModelAttribute(value="form")
    public Form getForm(PortletRequest request, PortletResponse response) {
        PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
        Bundle bundle = this.bundleFactory.getBundle(request.getLocale());
        Form form = (Form)this.applicationContext.getBean(Form.class);
        form.setTo(window.getProperty("osivia.contact.mailto"));
        form.setObject(window.getProperty("osivia.contact.object"));
        form.setFromLabel(StringUtils.defaultIfBlank((String)window.getProperty("osivia.contact.fromLabel"), (String)bundle.getString("ENTER_EMAIL")));
        form.setNomLabel(StringUtils.defaultIfBlank((String)window.getProperty("osivia.contact.nomLabel"), (String)bundle.getString("NAMES")));
        form.setObjectLabel(StringUtils.defaultIfBlank((String)window.getProperty("osivia.contact.objectLabel"), (String)bundle.getString("SUBJECT")));
        form.setBodyLabel(StringUtils.defaultIfBlank((String)window.getProperty("osivia.contact.bodyLabel"), (String)bundle.getString("MESSAGE")));
        FormCaptcha captcha = (FormCaptcha)this.applicationContext.getBean(FormCaptcha.class);
        if (StringUtils.isEmpty((String)captcha.getToken())) {
            GCage gcage = new GCage();
            captcha.setToken((String)gcage.getTokenGenerator().next());
        }
        form.setCaptcha(captcha);
        return form;
    }

    @ActionMapping(name="submit", params={"send"})
    public void sendMail(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") @Validated Form form, BindingResult result, SessionStatus status) throws PortletException, IOException {
        PortalControllerContext pcc = new PortalControllerContext(this.getPortletContext(), (PortletRequest)request, (PortletResponse)response);
        Bundle bundle = this.bundleFactory.getBundle(request.getLocale());
        Properties props = System.getProperties();
        Session mailSession = Session.getInstance((Properties)props, null);
        MimeMessage msg = new MimeMessage(mailSession);
        try {
            if (!result.hasErrors()) {
                status.setComplete();
                InternetAddress from = new InternetAddress(form.getFrom());
                msg.setFrom((Address)from);
                msg.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)form.getTo(), (boolean)false));
                msg.setSubject(form.getObject(), "UTF-8");
                MimeMultipart mp = new MimeMultipart();
                MimeBodyPart htmlPart = new MimeBodyPart();
                htmlPart.setContent((Object)ContactController.bodyFormat((Form)form, (Bundle)bundle), "text/html; charset=UTF-8");
                mp.addBodyPart((BodyPart)htmlPart);
                msg.setContent((Multipart)mp);
                msg.setSentDate(new Date());
                InternetAddress[] replyToTab = new InternetAddress[]{from};
                msg.setReplyTo((Address[])replyToTab);
                SMTPTransport t = (SMTPTransport)mailSession.getTransport();
                t.connect();
                t.sendMessage((Message)msg, msg.getAllRecipients());
                t.close();
                form.setSent(true);
            }
        }
        catch (MessagingException e) {
            throw new PortletException((Throwable)e);
        }
    }

    public void setPortletConfig(PortletConfig portletConfig) {
        this.portletConfig = portletConfig;
    }

    public void setPortletContext(PortletContext portletContext) {
        this.portletContext = portletContext;
    }

    @InitBinder(value={"form"})
    public void formInitBinder(WebDataBinder binder) {
        binder.addValidators(new Validator[]{this.formValidator});
        binder.setDisallowedFields(new String[]{"token", "captchaValidate"});
    }

    @ResourceMapping(value="captcha")
    public void captchaImage(ResourceRequest request, ResourceResponse response, @ModelAttribute(value="form") Form form) throws IOException {
        GCage gcage = new GCage();
        response.setContentType("image/" + gcage.getFormat());
        response.setProperty("Cache-Control", "no-cache");
        response.setProperty("Progma", "no-cache");
        gcage.draw(form.getCaptcha().getToken(), response.getPortletOutputStream());
    }

    @ActionMapping(name="submit", params={"reload"})
    public void reloadImage(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") Form form) {
        GCage gcage = new GCage();
        form.getCaptcha().setToken((String)gcage.getTokenGenerator().next());
    }
}

