/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.document.creation.plugin;

import fr.toutatice.portail.cms.nuxeo.api.cms.NuxeoDocumentContext;
import fr.toutatice.portail.cms.nuxeo.api.player.INuxeoPlayerModule;
import java.util.HashMap;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.osivia.portal.api.internationalization.Bundle;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.portal.api.internationalization.IInternationalizationService;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.api.player.Player;

public class DocumentCreationPlayer
implements INuxeoPlayerModule {
    private final IBundleFactory bundleFactory;
    private final Locale locale;

    public DocumentCreationPlayer(Locale locale) {
        this.locale = locale;
        IInternationalizationService internationalizationService = (IInternationalizationService)Locator.findMBean(IInternationalizationService.class, (String)"osivia:service=InternationalizationService");
        this.bundleFactory = internationalizationService.getBundleFactory(this.getClass().getClassLoader());
    }

    public Player getCMSPlayer(NuxeoDocumentContext documentContext) {
        if (documentContext.getDocument() != null && StringUtils.equals((String)documentContext.getDisplayContext(), (String)"onlyoffice")) {
            Bundle bundle = this.bundleFactory.getBundle(this.locale);
            HashMap<String, String> windowProperties = new HashMap<String, String>();
            windowProperties.put("osivia.cms.uri", documentContext.getDocument().getPath());
            windowProperties.put("osivia.hideTitle", "1");
            windowProperties.put("osivia.onlyoffice.withLock", Boolean.TRUE.toString());
            windowProperties.put("osivia.title", bundle.getString("ONLYOFFICE_EDIT"));
            Player onlyofficePlayer = new Player();
            onlyofficePlayer.setWindowProperties(windowProperties);
            onlyofficePlayer.setPortletInstance("osivia-services-onlyoffice-portletInstance");
            return onlyofficePlayer;
        }
        return null;
    }
}

