/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.document.creation.portlet.controller;

import fr.toutatice.portail.cms.nuxeo.api.CMSPortlet;
import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.cms.NuxeoDocumentContext;
import fr.toutatice.portail.cms.nuxeo.api.services.dao.DocumentDAO;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import javax.annotation.PostConstruct;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.model.Document;
import org.osivia.portal.api.internationalization.Bundle;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.portal.api.internationalization.IInternationalizationService;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.api.notifications.NotificationsType;
import org.osivia.portal.api.windows.PortalWindow;
import org.osivia.portal.api.windows.WindowFactory;
import org.osivia.services.document.creation.portlet.command.UploadFileCommand;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.portlet.bind.annotation.ActionMapping;
import org.springframework.web.portlet.bind.annotation.RenderMapping;
import org.springframework.web.portlet.context.PortletConfigAware;
import org.springframework.web.portlet.context.PortletContextAware;

@Controller
@RequestMapping(value={"VIEW"})
public class DocumentCreationController
extends CMSPortlet
implements PortletContextAware,
PortletConfigAware {
    private static final String BLANK_DOCX_PATH = "/WEB-INF/classes/blank.docx";
    private static final String BLANK_XLSX_PATH = "/WEB-INF/classes/blank.xlsx";
    private static final String BLANK_PPTX_PATH = "/WEB-INF/classes/blank.pptx";
    private static final String DEFAULT_VIEW = "view";
    private final IBundleFactory bundleFactory;
    private PortletContext portletContext;
    private PortletConfig portletConfig;

    public DocumentCreationController() {
        IInternationalizationService internationalizationService = (IInternationalizationService)Locator.findMBean(IInternationalizationService.class, (String)"osivia:service=InternationalizationService");
        this.bundleFactory = internationalizationService.getBundleFactory(this.getClass().getClassLoader());
    }

    @PostConstruct
    public void postConstruct() throws PortletException {
        super.init(this.portletConfig);
    }

    @RenderMapping
    public String view(RenderRequest request, RenderResponse response) throws PortletException {
        request.setAttribute("error", (Object)request.getParameter("error"));
        return DEFAULT_VIEW;
    }

    @ModelAttribute(value="docType")
    public String getDocType(PortletRequest request, PortletResponse response) {
        PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
        return window.getProperty("osivia.services.document.creation.type");
    }

    @ModelAttribute(value="docExt")
    public String getDocExt(PortletRequest request, PortletResponse response) {
        PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
        String docType = window.getProperty("osivia.services.document.creation.type");
        return this.getExtensionByDocType(docType);
    }

    @ModelAttribute(value="docIcon")
    public String getDocIcon(PortletRequest request, PortletResponse response) {
        PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
        String docType = window.getProperty("osivia.services.document.creation.type");
        return DocumentDAO.getInstance().getIcon(docType);
    }

    @ModelAttribute(value="modalTitle")
    public String getModalTitle(PortletRequest request, PortletResponse response) {
        PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
        String docType = window.getProperty("osivia.services.document.creation.type");
        return this.getDocTypeKey(docType);
    }

    private String getDocTypeKey(String docType) {
        if (StringUtils.equals((String)docType, (String)"application/vnd.openxmlformats-officedocument.wordprocessingml.document")) {
            return "NEW_WORD_DOCUMENT";
        }
        if (StringUtils.equals((String)docType, (String)"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet")) {
            return "NEW_EXCEL_DOCUMENT";
        }
        if (StringUtils.equals((String)docType, (String)"application/vnd.openxmlformats-officedocument.presentationml.presentation")) {
            return "NEW_POWERPOINT_DOCUMENT";
        }
        return "NEW_WORD_DOCUMENT";
    }

    private InputStream getBlankStreamByDocType(String docType) {
        if (StringUtils.equals((String)docType, (String)"application/vnd.openxmlformats-officedocument.wordprocessingml.document")) {
            return this.portletContext.getResourceAsStream(BLANK_DOCX_PATH);
        }
        if (StringUtils.equals((String)docType, (String)"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet")) {
            return this.portletContext.getResourceAsStream(BLANK_XLSX_PATH);
        }
        if (StringUtils.equals((String)docType, (String)"application/vnd.openxmlformats-officedocument.presentationml.presentation")) {
            return this.portletContext.getResourceAsStream(BLANK_PPTX_PATH);
        }
        return this.portletContext.getResourceAsStream(BLANK_DOCX_PATH);
    }

    private String getExtensionByDocType(String docType) {
        if (StringUtils.equals((String)docType, (String)"application/vnd.openxmlformats-officedocument.wordprocessingml.document")) {
            return ".docx";
        }
        if (StringUtils.equals((String)docType, (String)"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet")) {
            return ".xlsx";
        }
        if (StringUtils.equals((String)docType, (String)"application/vnd.openxmlformats-officedocument.presentationml.presentation")) {
            return ".pptx";
        }
        return ".docx";
    }

    @ActionMapping(name="newDoc")
    public void newWordDoc(ActionRequest request, ActionResponse response) throws PortletException {
        boolean isOnlyofficeRegistered;
        NuxeoController nuxeoController = new NuxeoController((PortletRequest)request, (PortletResponse)response, this.getPortletContext());
        Bundle bundle = this.bundleFactory.getBundle(request.getLocale());
        PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
        Document createdDocument = null;
        try {
            String docType = window.getProperty("osivia.services.document.creation.type");
            String path = window.getProperty("osivia.cms.uri");
            if (StringUtils.isNotEmpty((String)path)) {
                path = nuxeoController.getComputedPath(path);
                NuxeoDocumentContext documentContext = nuxeoController.getDocumentContext(path);
                Document currentDocument = documentContext.getDocument();
                nuxeoController.setCurrentDoc(currentDocument);
                String newDocName = request.getParameter("newDocName");
                if (StringUtils.isNotBlank((String)newDocName)) {
                    String newDocExtension = this.getExtensionByDocType(docType);
                    InputStream blankStreamByDocType = this.getBlankStreamByDocType(docType);
                    UploadFileCommand uploadFileCommand = new UploadFileCommand(blankStreamByDocType, newDocName + newDocExtension, docType, currentDocument.getId());
                    createdDocument = (Document)nuxeoController.executeNuxeoCommand((INuxeoCommand)uploadFileCommand);
                    this.addNotification(nuxeoController.getPortalCtx(), "NEW_DOC_CREATED_SUCCESS", NotificationsType.SUCCESS);
                } else {
                    response.setRenderParameter("error", this.getBundleFactory().getBundle(request.getLocale()).getString("NEW_DOC_TITLE_REQUIRED"));
                }
            }
        }
        catch (Exception e) {
            this.addNotification(nuxeoController.getPortalCtx(), "NEW_DOC_CREATED_ERROR", NotificationsType.ERROR);
            throw new PortletException((Throwable)e);
        }
        if (createdDocument != null && (isOnlyofficeRegistered = nuxeoController.getNuxeoCMSService().getCMSCustomizer().getCustomizationService().isPluginRegistered("onlyoffice.plugin"))) {
            try {
                HashMap<String, String> windowProperties = new HashMap<String, String>();
                windowProperties.put("osivia.cms.uri", createdDocument.getPath());
                windowProperties.put("osivia.hideTitle", "1");
                windowProperties.put("osivia.onlyoffice.withLock", Boolean.TRUE.toString());
                windowProperties.put("osivia.title", bundle.getString("ONLYOFFICE_EDIT"));
                String onlyofficePortlerUrl = nuxeoController.getPortalUrlFactory().getCMSUrl(nuxeoController.getPortalCtx(), null, createdDocument.getPath(), null, null, "onlyoffice", null, null, null, null);
                response.sendRedirect(onlyofficePortlerUrl);
            }
            catch (IOException e) {
                throw new PortletException((Throwable)e);
            }
        }
    }

    public void setPortletConfig(PortletConfig portletConfig) {
        this.portletConfig = portletConfig;
    }

    public void setPortletContext(PortletContext portletContext) {
        this.portletContext = portletContext;
    }
}

